META
key;value
description;District PB in Warszawa, Praga-Północ
country;Poland
unit;Warszawa
district;Praga-Północ
subunit;Praga-Północ
instance;2024
num_projects;52
num_votes;2601
budget;2637105
vote_type;approval
rule;greedy
date_begin;15.06.2023
date_end;30.06.2023
max_length;15
edition;10
language;pl
currency;PLN
comment;#1: The metadata regarding the age of voters shows very low values (starting from zero), indicating that one doesn't need to be an adult to vote: If a voter is under 13, they can vote with the consent of a parent or guardian. Hence, for example, age 0 likely corresponds to cases where parents/guardians are voting on behalf of their children. #2: Due to a voting system glitch, twelve voters mistakenly cast ballots for projects in two different districts, violating regulations. To align with city-wide results, we tagged these voters with the prefix 999999 and separated their ballots into two distinct votes. The final election outcome was not affected.
PROJECTS
project_id;cost;votes;name;category;target;selected;latitude;longitude
476;498080;1440;Nowe drzewa i krzewy dla Pragi;environmental protection,public space,urban greenery;children,seniors;1;52.25904952216355;21.044899065097653
491;350000;1191;Wyrzucamy beton - sadzimy zieleń na Pradze;environmental protection,public space,urban greenery;children,seniors;1;52.260319949999996;21.033318967107775
225;527421;1170;Zielone ulice Pragi;public transit and roads,environmental protection,public space,urban greenery;children,seniors;1;52.25992055623785;21.04016017441918
1200;105000;1119;500 krzewów dla Pragi.;environmental protection,public space,urban greenery;children,seniors;1;;
921;191160;1081;Zielone ściany dla Pragi;environmental protection,public space,urban greenery;children,seniors;1;52.257795050000006;21.05346656932785
1556;21000;1064;Sadzimy drzewa w Parku Praskim;environmental protection,urban greenery;children,seniors;1;52.25270209999999;21.029840270016763
331;37000;988;Budki lęgowe dla drobnych ptaków owadożernych (przeciw komarom i innym uciążliwym owadom);education,environmental protection,public space,urban greenery;children,seniors;1;52.25622279735147;21.03576614421387
460;527400;960;Nowe zielone skwery Pragi;environmental protection,public space,urban greenery;children,seniors;1;52.25941101056558;21.05066299438366
933;190000;949;Chrońmy zieleń na Pradze;environmental protection,public space,urban greenery;children,seniors;1;52.26007858333333;21.030168323748182
470;527000;936;Nowa zieleń przyuliczna w miejsce betonu;public transit and roads,environmental protection,public space,urban greenery;children,seniors;0;52.2511468;21.0306277
1603;47000;915;Ratujmy praskie kasztanowce - kontynuacja;environmental protection,public space,urban greenery;children,seniors;1;;
370;527250;884;Rozbetonowujemy i ukwiecamy praskie podwórka;environmental protection,public space,urban greenery;children,seniors;0;52.26160159122384;21.044545371644617
1632;170000;787;Ratujmy praskie kapliczki;education,culture,public space;children,seniors;0;52.25495178999999;21.040488034169773
1101;78000;780;Kocham Pragę. Neon dzielnicy;culture,public space;children,seniors;1;52.25187721901332;21.02918386459351
803;249600;768;Zielone Rondo Starzyńskiego;public transit and roads,public space,urban greenery;children,seniors;0;52.2640859;21.0217273
1089;85000;748;Pomoc dla kotów wolno żyjących i bezdomnych na terenie Dzielnicy Praga-Północ;environmental protection;;0;;
352;50000;724;Czyste ulice Pragi - montaż pokrywek na kosze na śmieci;environmental protection,public space,urban greenery;children,seniors;1;;
359;62550;687;Stop latającym śmieciom - przykrywamy praskie śmietniki;environmental protection,public space;children,seniors;0;52.25893222669267;21.048407545992646
238;215000;685;Nowoczesna i aktywna praska Biblioteka;education,culture;children,seniors;0;52.2588993;21.0277237
1370;20000;666;Dofinansowanie Biblioteki Publicznej na zakup nowości wydawniczych;culture;children,seniors;0;52.2588993;21.0277237
358;10800;590;Cała Praga na rowery - nowe stojaki rowerowe;public transit and roads,public space,sport;children,seniors;1;52.26043816666667;21.031742556966098
1313;77000;558;Zielona Brzeska - finał. Kocham Pragę!;education,public transit and roads,public space,urban greenery;children,seniors;0;52.25413084138236;21.03967666625977
1266;70400;511;Darmowe wejścia na basen dla dzieci i młodzieży szkolnej;sport;children;0;52.2500733;21.0363767
1355;250000;485;Jordanek - zielone i naturalne miejsce zabaw. Kocham Pragę!;education,public space,sport,urban greenery;children,seniors;0;52.2591762415597;21.058237552642822
1108;520000;443;Pumptrack przy Targowej. Kocham Pragę;public space,sport;children;0;52.2574903;21.03266102879205
1661;67000;442;Dobry start czyli na Pradze Północ bez korepetycji;education;children;0;52.249849;21.036805851577046
538;150000;437;Siłownia plenerowa. Kocham Pragę;sport;children,seniors;0;52.25973395;21.03206923039555
1651;200000;427;Biblioteka w nowej odsłonie;education,culture;children,seniors;0;52.2595512;21.0531945
603;32700;411;Joga na Pradze-Północ;sport;seniors;0;52.2586358;21.061430306306992
724;270000;389;Nowoczesna siłownia plenerowa ze zmiennym obiążeniem;education,public space,sport;children,seniors;0;52.2574903;21.03266102879205
548;80000;376;Praskie potańcówki międzypokoleniowe;education,culture,sport;children,seniors;0;52.26434378982566;21.03184032440186
159;12500;310;Pieskowy skwerek serek koło paczkomatu Bródnowska;education,public transit and roads,environmental protection,public space,urban greenery;children,seniors;0;52.26421778466458;21.0399341583252
395;24000;297;Zielone Biblioteki - zakup kwiatów i roślin do Praskich Bibliotek;environmental protection,public space,urban greenery;children,seniors;0;52.264142275;21.022820366915447
805;20000;294;Zdrowy kręgosłup w VII Ogrodzie Jordanowskim;education,sport;children,seniors;0;52.26580515288121;21.030535697937015
398;25000;291;Rodzinne niedziele na basenie DOSiR;education,sport;children;0;52.249849;21.036805851577046
802;50500;286;Lekcje gry w szachy na Pradze;culture,sport;children,seniors;0;52.2637618;21.027270864445992
1606;19000;273;Jak i czym - kampania dotycząca dokarmiania ptaków zimą - kontynuacja;environmental protection,public space,urban greenery;children;0;;
1709;49900;268;Monitoring na ul. Wołomińskiej 19, ul. Siedleckiej 1/15, ul. Siedleckiej 16/24;public space;children,seniors;0;52.257782369635706;21.054439544677738
801;42000;261;Lekcje ekonomii i warsztaty prawnicze dla mieszkańców Pragi;education,welfare;children,seniors;0;;
943;420000;231;Biblioteka ekologiczna;education,culture;seniors;0;52.2658476;21.017245926399546
817;35000;221;Spotkania kulturowe dla mieszkańców Pragi-Północ;education,culture;children,seniors;0;52.2614898;21.03956142327908
804;43285;210;Korektywa dla dzieci w DOSiR;education,sport;children;0;52.2586358;21.061430306306992
806;497000;207;Zielony i funkcjonalny Golędzinów;public transit and roads,environmental protection,public space,sport,urban greenery;children,seniors;0;52.2658929;21.01994455179182
1663;49900;205;Monitoring w obrębie Przedszkola nr 171;environmental protection,public space,urban greenery;children,seniors;0;52.25956861927591;21.043453216552738
1724;43000;205;Poprawa estetyki ul. Łomżyńskiej - montaż koszy i kwietników;public space;children,seniors;0;52.260953650000005;21.055718866737163
604;23000;194;Zajęcia taneczne dla dzieci;education,culture,sport;children;0;52.2586358;21.061430306306992
799;37125;187;Zajęcia taneczne na Pradze-Północ;education,sport;children,seniors;0;52.26592215;21.030372232321202
853;10000;186;Cała Praga tańczy. Zielony karnawał. Międzypokoleniowy Kurs Tańca Towarzyskiego z instruktorem i z zespołem muzycznym;education,culture,welfare;seniors;0;52.26001555;21.040182182142857
277;150000;164;Siłownia plenerowa przy ZSS nr 38;sport;children,seniors;0;52.26559315;21.032028606305254
760;197400;162;Cyfrowa szkoła – Laboratorium przyszłości w SP73;education,public space;children;0;52.254049300000005;21.039242720799727
605;30372;157;Treningi obwodowe dla dorosłych na hali sportowej;sport;;0;52.264100400000004;21.030590182599433
381;37500;127;Gordonki i edusensorki dla dzieci w VII Ogrodzie Jordanowskim;education,culture;children;0;52.26592215;21.030372232321202
VOTES
voter_id;vote;age;sex
1;933,460;44;F
2;1089,352,603,359,1603,1632,225,1370,548,803;37;F
169;1313,760;42;F
265;277;37;M
286;802,331,1632,491,225,1603,1200,359,933,603,476,1101,460,1313,921;45;F
336;491,460,225,1603,370,803,933,1556,352,331,1200,1370,476,238,1089;44;F
344;277;39;M
446;1632,381,1603,1370,1663,1266,1355,398,238,604;35;F
478;548,604,921,1632,225,802,803,603,805,277;31;F
537;1632,1603,1661,1266,933,1556,1313,1200,817,1651,1709,238,1724,921;53;F
541;225,352,491,1355,359,370,470,802,1200,803,724,603,476,921,538;30;M
551;1355,805,277;47;F
666;225,1603,1200,921,352,1089,491,724,359,1108,370,817,1370,799,331;30;F
729;460,1606,1200,1661,801,804,398,395;22;M
806;1651,933,1355,238,921,1370,352,470,225,460,1313,359,1556,476,491;37;F
816;370,1266,804,724,1556,398,604,538,352,359;50;M
848;1089,352,358,331,1200,1370,225,806,802,470,803,1556,395,476,491;45;F
923;933,359,803,1108,1266,1661,1370,358,460,331,470,603,476,491,1089;53;F
956;1663,802,801,1661,943,1370,799,331,760,460,1632,381,1266,1108,1355;27;F
1054;1661;49;F
1060;1089,491,476,1556,933,370,470,801,817,1370,1200,1603,225,460,1632;33;F
1086;277;45;F
1101;1651;52;M
1153;1313,1632,1370,817,943,1651,1101,238;36;F
1243;1651,921,933,225,460,331,358,1632,1603,1200,1370,803,476,238,1089;37;F
1270;359,1556,491,225,460,470,370,803,933,1355,1632,1603,802,476,277;44;M
1297;1606,225,806,1661,370,1266,921,352,491,476,1556,933,1200,1632,331;30;M
1347;1370,1661,1266,803,1556,1355,476,1101,491,398,805,1089,604,921,538;18;F
1363;1632,225,1603,159,359,1556,476,460,331,1200,470,370,933,491,1089;50;F
1372;1200,1370,603,238,1108,1663,1556,331,159,476,724,225;29;F
1409;799,1661,801,1266,853,604,538;36;F
1431;476,491,1709,238,921,460,225,1200,943,470,370,1556,724,331,1089;36;F
1444;1663;34;F
1454;803,724,277,1101,538;38;M
1518;331,1603,1200,803,476,921;57;F
1530;225,1661;49;M
1577;1200,225,331,1603,1370,817,801,802,470,803,603,476,491,238,921;44;F
1687;817,799,225,460,1200,1370,853,476,491,398,548,238,604,352,1661;41;F
1829;1651;72;F
1851;760,1089,358,1313,460,1200,1661,1663,1108,803,724,1556,1101,491,1709;20;M
1915;225,1603,1200,470,370,933,1556,603,1355,476,1101,491,238,1089,921;30;F
1961;1313,760,1661,604;39;F
2002;1556;33;F
2030;470,803,933,476,491,238,1089,921,1101,359,159,1200,1603,225,1632;31;F
2049;476,159,331,1556,1663,1108,238,603,1370,1200;25;M
2078;460,1313,225,1603,806,1200,159,801,470,370,1266,933,1556,476,352;44;F
2126;358,1200,1108,921,1709,605,1556,1370,724,603,491,1089,476,352,359;35;F
2156;1663,491;30;F
2191;470,370,1556,476,804,801,817,331,1606,1632,1661,1266,803,1101,491;30;F
2408;460,1313,1266,1556,491,805,538,804,476;41;F
2434;1632,460,331,225,1603,1200,470,370,803,933,1556,476,491,921,352;27;F
2472;277;57;F
2615;933,1556,1606,331,370,395,491,460,225,1200,159,359,476,921,352;38;F
2717;817,1651,1089,548;23;M
2729;1632,460,225,1200,801,470,370,1266,933,1556,395,476,1101,491,921;39;F
2778;1661,724,1709,238;38;F
2825;238,1370,1651;48;F
2871;1632,358,799,1200,470,1663,1266,398,1709,548;39;F
2887;1556,491,921,1663,238,476,395,1266,358,1632,1313,460,760,225,1370;44;F
3198;1606,1632,460,331,225,1603,802,1266,603,476,921,1661,1108,491,1089;47;F
3249;1370,802,395,1355,238;61;F
3261;331,1370,277,1200,1108,803,359,724,933,1556,476,491,921,538,352;39;M
3469;1651,724,277,805,1632,1200,1370,801,802,1108,921,352,331,1313,1089;40;F
3476;1370,1651,238;45;F
3637;331,1200,801,370,933,1556,476,491;25;F
3643;803,359,1355,538,331,1266,804,605,724,1556,603,491,398,604,1661;42;M
3785;370,1266,804,605,724,1556,395,1355,398,604,921,352,1632,331,1709;27;F
3956;1089;40;M
3988;460,760,799,817,1663,370,804,603,853,398,805,548,238,921,604;29;F
4078;277;49;F
4083;1651,225,1200,470,1108,476,491,460,358,331,1370,370,359,238,352;37;M
4120;352,331,760,460,225,1200,470,603,921,1632,802,476,1709,238,1724;51;M
4131;605,801,817,1200,1603,331,1632,460,1724,1101,603,491,805,548,921;29;M
4192;331,225,1603,1200,159,470,370,359,933,1556,476,491,352,1089,1313;60;F
4338;817,1661,1651,724,1355,805,604,1370,476,538,1266,1556,1101,398,238;36;F
4403;1661,1663,370,277,1709,238,604,538,1632,802,1266,1108,724,1355,1101;34;F
4472;1370,1651,238;44;F
4493;491,1266,943,1370,1651;74;F
4605;476,605,933,1101,370,470,225,460,359,358,799,603,277,491,921;40;F
4644;395,1089,1606,331,225,1603,1200,159,470,1108,803,1556,476,1101,352;39;M
4698;358,331,799,159,1266,804,359,853,476,491,805,548,352,921,1661;45;F
4738;1313,799,1200,1266,1651,803,1556,476,1101,805,352,358,1603,1370,1108;46;F
4745;1313,1663,1266,804,359,398,604;34;F
4814;352,921,358,460,933,476,491,1200,806,803;39;M
4865;370,933,491,352,1313,460,470,803,1556,1101,1089,921,476,1200,225;45;M
4875;799,398,1661;34;F
5121;277,1632,331,1661,801,1663,1266,804,1556,805,1709,238,1724,352,1089;29;M
5169;277;55;M
5233;538,921,491,277,370,470,799,1603,331,460,358,225,1200,1101;29;F
5388;277;57;M
5389;1603,460,358,225,1200,1661,470,370,933,1556,1355,476,1101,491,921;44;F
5427;460,1632,358,331,225,1603,1200,159,801,470,803,933,1556,603,476;43;F
5474;1370,1556,491,1724,921,943,1651,395,238;63;F
5515;1603,1108,548,1632,1663,460,358,225,470,370,724,933,476,491,921;37;M
5558;1556,933,806,331,1313,460,225,1200,470,370,803,724,476,359,159;27;M
5586;277,1101,921,352,803,1108,1266,370,470,1661,1200,225,358,460,476;34;F
5652;238,460,225,1603,1370,1661,470,1266,1556,603,476;43;F
5676;225,1603,806,1200,470,370,803,359,933,1556,476,1101,491,921,352;25;M
5874;331,1556,803,1603,460,358,225,470,370,359,724,933,476,491,921;30;F
6033;359,933,603,1101,491,352,460,331,225,1603,1200,803,476,921,1632;28;F
6119;476,1089,1200,225;31;M
6123;1313,225,1603,1200,470,933,1556,921,476;32;F
6327;358,331,1606,1603,1200,1370,802,1266,605,1556,603,460,470,476,1724;51;M
6331;277;65;M
6387;381,1200,805,1089,358,331,803,238,603,548,370;38;F
6476;1556,921,352;46;M
6491;933,548,1089,1632,460,331,159,801,370,359,476,1101,491,921,352;31;F
6505;1632,460,225,1603,1200,470,359,933,476,491;31;M
6744;605,933,1556,853,476,1101,491,398,805,538,1632,460,358,225,1663;70;F
6750;921,799,1200,1266,804,359,1101,805,398,1632,358,331,225,1663,352;36;M
6808;1266,1200,225,470,1661,802,1108,398;39;F
6820;817,1663,548,352,1632,358,1606,331,225,1603,1370,933,476,1101,1089;45;M
6896;1632,331,1603,159,370,476,491,1089;43;F
6902;1724,921,476,933,358,460,225,1200,470,370,1266,803,1556,1101,491;41;F
7063;933,1556,1724,1313,460,225,1632,331,1200,1661,476,491,238,1089,921;24;F
7182;1108,460,381,724,1355,331,1603,803,1101,921,370;45;M
7218;460,806,801,470,370,803,359,933,476,1101,491,1709,238,538,352;27;M
7310;1606,460,225,370,352,1266,1632,331,1603,1661,359,933,1556,476,491;37;F
7334;1603,1370,1632,1313,933,470,1556,476,603;38;M
7358;933,1632,1200,803,491,921,460,225,476;23;M
7396;804,1651,1556,476,398,604,921,760,1603,1661,1663,1266,238,538,1370;42;F
7409;605,804,370,1370,331,460,358,806,1603,1200,1108,491,1556,724,277;30;M
7440;1313,358,799,1200,802,1266,1556,491,398;45;M
7524;352,921,359,1632,358,331,225,1603,1200,1556,603,476;40;F
7612;225,1108,476,1089;32;M
7700;1313,853,491,548;29;M
7731;1108,724,277;20;F
7750;460,225,921,238,1313,1370,1200,1651,476,1632;60;M
7765;1313,331,225,806,1200,803,476,921,1603,470,933,1556,1101,548,1089;39;F
7779;476,1200,1556,470;32;M
7910;370,359,803,277,352;45;F
7928;277;43;F
8000;1661;60;F
8007;1556,933,370,159,806,225,460,1313,1603,1200,1370,470,803,476,238;34;F
8068;760,331;58;F
8083;1313,460,225,1200,470,370,933,476,491,921;41;F
8188;470,1370,1603,1606,358,1313,331,225,548,1089,159,476,1101,491,921;26;F
8237;1370,225,381,799,1661,802,1266,804,1651,603,1355,398;6;M
8274;352,1101,1556,933,803,470,1200;37;M
8395;277;50;F
8529;801,1661,1370,799,1606,802,1266,804,605,603,1355,398,805,238,604;39;F
8538;358,225,352,491,470,359,1200,806,803,476;37;M
8654;159,853,277,398,548,238,1089,1370,1661,1663,1266,804,1651,1101,604;27;F
8676;470,370,359,933,803,476,1101,460,1313,1556,491,548,238,921,538;23;M
8693;805,548,921,1355,853,603,1556,803,1663,802,1661,1200,799,1266,1101;35;F
8978;603,1089,1724,470,1101,933,1632,460,370,225,352,1200,476,491,921;54;F
9035;603,398,805,604,1632,1200,1266,1556,1355,538,331,1603,803,476,1101;49;M
9042;804,803,1556,395,805,238,1089,604,921,802,933,724,476,491,352;42;F
9269;1606,238,805,605,1661,817,1370,803,933,491,921,331,1603,1089;39;F
9297;805,538,381,1200,1370,359,724,238,352,1632,460,358,331,1108,1355;43;F
9302;1355,395,359,803,370,1200,1603,225,1606,331,933,1556,476,491,1089;48;M
9337;460,225,470,359,476,921,1603,1200,724,933,1556,603,491,538,352;38;M
9401;1606,331,358,460,225,1200,370,803,933,395,1355,476,491,1089,921;47;F
9418;277;35;F
9487;225,1603,1200,803,933,1556,476,1101,491,1709,921;33;M
9494;921,1089,548,491,1101,476,1556,803,1108,370,1200,1603,225,331,1632;35;F
9500;1632,491,921,470,1108;38;M
9514;1370,1200,1603,370,803,933,476,491,352;43;M
9537;724,1556,476,1709,921,352,1632,1313,358,1370,370,1266,1108,359,491;32;F
9568;1556,933,359,1266,370,470,1661,1200,225,331,817,803,476,491,921;27;F
9598;1632,1200,1108,1603,225,1313,460,476,352,238,395,1651,943,1370,359;52;F
9635;1632,358,225,1200,370,603,476,491;32;F
9648;476,921,238,1709,933,802,1370,1313,460,331,225,1603,1200,1661,1089;33;F
9773;921,1089,1632,1603,370,352;54;M
9774;460,225,1603,1370,548,1089,476,1556,470,370,331,1200,491,921,803;40;M
9789;159,1200,799,331,460,225,1661,803,724,933,1556,603,476,491,921;29;F
9812;1200;26;F
9836;358,331,225,1603,806,1200,470,370,1108,933,476,491,548,1313,159;35;F
9920;460,358,1603,1200,470,370,1108,803,933,1556,1355,476,1101,491,921;37;M
10004;1313,460,358,331,225,1603,1200,470,370,803,933,1556,476,1101,921;35;F
10096;1709,1101,1556,933,1370,1200,1603,225,460,1632,331,159,476,491,1089;24;F
10116;1632,1313,331,159,476,1101,491;32;F
10123;1661,817,799,1101,801;21;F
10147;460,331,225,1603,1200,470,803,933,1556,395,1355,476,491,1089,921;38;F
10290;803,603,238,1089,331,225,1603,1200,159,724,1556,476,805,352,538;36;M
10471;358,1606,370,803,476,1101,491;29;F
10548;1556,460,225,1603,1200,470,370,803,933,476,491,921;35;F
10586;1108,460,801,803,1556,1709;28;M
10633;1724,538,603,921,352,225,1603,806,1200,803,933,1556,476,1101,1089;21;M
10738;460,1200,933,1556,1266,1101,1370,1661,1651,603,1709,238,1724;44;F
10795;460,921,352,331,1200,470,1556,476,491,238,225,1603,370,359,933;38;M
10997;1355,491,370,358,225,1603,1200,1370,470,1266,476,548,1089,352,331;24;M
10999;1606,460,331,225,1200,1603,159,801,1663,359,933,476,238,352;35;M
11020;1266,804,603,238,604,358,1661,398,805;39;F
11118;724,933,277,548,1089,1632,1603,1200,470,803,1556,476,853,1101,921;76;F
11156;470,1663,804,605,933,1556,476,1101,1709,352,1370,1661,1266,1108,491;39;F
11157;1661,1266,603,398;40;F
11158;1632,331,1556,933,476,491,921,803,724,1313,460,225,1200,470;34;M
11167;1606,331,225,804,803,933,853,1355,476,491,805,1709,548,1089,352;69;F
11188;1200,470,803,491,760,358,225,359,1556,933,476,1709,921,352,1663;25;M
11196;1632,225,1200,470,476,921;46;M
11201;331,1370,1661,470,1651,1108,803,933,1556,395,1355,476,238,1089,921;40;F
11314;460,225,1370,159,1663,370,1266,804,933,603,476,491,548,1089,921;34;F
11380;1313,460,225,1200,1370,1661,1663,1266,804,933,476,491,238,1089,921;39;M
11456;1313,460,1606,331,225,1603,1200,470,476,1089,921,1108;33;F
11458;760,331,1370,159,1266,359,1556,603,1355,1101,491,238,604,921,352;36;F
11551;225,358,803;32;M
11579;1200,1603,331,358,225,802,1108,724,1556;43;M
11733;1651,853,476,805,604,352,381,159,1663,1266,359,603,1355,398,1089;36;F
11742;225,238,352,370,470,476,491,803,933,943,1101,1108,1200,1370,1556;43;M
11796;1663;44;M
11860;476,460,359;42;M
11933;921,1556,933,803,370,1200,1603,225,358,460,1313,470;34;M
11946;943,370,803,933,1355,538,460,1313,225,1200,1108,724,476,1101,491;28;M
11953;1556,933,803,370,470,1200,1603,225,381,358,476,491,805;63;M
11954;853,603,933,1266,370,470,1661,225,760;34;F
11959;1101,491;31;F
11991;1603,1556,352,460,1606,225,1200,470,370,476,491,921,331,1089;37;F
12027;1313,331,724,277,1101,538;31;M
12070;1632,370,603,476,1101,491,805,548,238;45;F
12076;1632,225,1603,1370,801,802,395,603,491,921,352,331,1200,476,470;33;F
12108;1266,817,1200,1370,331,460,1632,358,1603,370,1556,476,491,238,921;41;F
12144;238;51;M
12184;1313,460,331,225,1603,1200,470,803,359,933,491,1101,476;29;M
12192;1709,548;36;F
12235;806,1200,470,370,803,359,1101,491,921,331,225,1603,933,1556,476;45;M
12283;1632,460,331,225,1603,1200,470,370,803,1556,476,1101,491,1089,921;25;F
12339;802,470,1266,1651,853,352,358,806,943,803,1556,491,548,238,921;28;F
12343;933,1651,1266,1663,470,802,1370,1603,225,760,358,1632,1101,491,398;41;M
12390;1370,943,395,538,1651,1556,603,1355,1101,805,1089,238,1632,331,1663;40;F
12458;933,460,225,760,1603,1200,1661,1556,476,1709,238,1632,331,1370,1663;38;F
12477;933,331,476,921;50;F
12499;1632,1313,225,1266,1101,398,1663;35;M
12562;225,933,476,921,943,1200,1603,331,806,803,1101,548;21;M
12607;359,352,1632,225,1200,159,1556;31;M
12642;1632,370,491,1724;34;M
12656;331,803,491;18;F
12733;470,802,159,1370,799,460,331,225,1200,817,803,603,1101,491,1089;36;F
12749;225,1200,159,370,359,933,1556,352,491;30;F
12769;352,803,370,159,1370,1200,1606,331,225,1603,724,1556,476,1101,1089;32;F
12811;358,760,1603,1108,605,933,603,476,352,802,1200,331,1606,1661,1089;45;F
12957;1370,921,398,277,476,1355,603,1556,724,803,605,1661,1266;42;M
13002;277;44;F
13258;460,225,806,370,933,476,1606,331,1603,359,1556,603,1355,491,1089;49;F
13315;370,803,359,933,1556,1355,476,491,352,460,1603,1370,1108,238,921;36;F
13334;1724,1089,1709,1101,1355,853,603,1556,605,1266,1200,1313,460,1606,799;23;F
13377;395,1089,921,352,1632,358,1606,331,225,1603,1200,724,933,1556,476;41;M
13437;460,358,331,225,1200,470,370,803,933,1556,603,476,491,1709,921;35;M
13704;799,1200,806,331,460,225,1603,803,933,1556,603,476,491,1089,921;26;F
13837;225,1200,1370,470,803,1556,603,1355,331,1603,1651,476,1101,491,238;46;F
13971;359,1200,806,921,805,476,724,225,331,460,799,605,603,853,1089;26;F
14012;1632,1606,1603;44;M
14108;1313,760,331,1089;12;F
14119;943,817,460,331,225,1603,1200,1370,470,1651,933,476,395,491,238;32;F
14179;1724,358,460,225,1603,806,1200,470,370,803,1556,933,476,491,921;40;M
14198;1266,921,538,331,1632,760;50;F
14219;277,491,1101,921,538,331,225,159,370,803,724,476;26;M
14247;1632,1200,1556,476,1101,817;37;M
14395;760,331;11;F
14401;476,1724,538,352,238,1632,358,331,1603,1200,1370,817,548;28;F
14409;1108,238,370,933,1709,1724,921,460,225,799,1200,359,603,476,352;77;F
14450;1313,1632,460,331,1603,1200,801,491,359,1556,476,225,1661,1663;41;F
14459;331,760;51;M
14475;358,760,943,1266,921;40;F
14508;491,1101,395,470,1603,331,460,1200,1370,370,803,359,476,921,1556;48;F
14540;799,1108,1266,225,1200,331,491;38;F
14690;1663,801,225,1313,1200,802,724,1709,1355,803,370,1089,277,1101;21;F
14753;1724,225,799,1606,760,1632,460,331,370,476,491,548,238,1089,921;58;F
14921;603,1266,370,1651,605,803,359,395,277,1355,491,238,921,538,352;50;F
15062;806,933,460,225,1603,1200,470,370,1556,491,476,1606,331,159,1089;36;M
15154;398,1266,806,1313,760,331;41;F
15225;1632,548,470,1651,933,395,853,476,491,238,1089,225,1370,1266,1661;33;F
15276;1313,760,331,806,1266,398;13;M
15324;352,1661,1200,1603,225,331,760,358,801,470,1266,804,359,1556,476;33;F
15352;1313,760,331,806,1266,398;12;M
15590;799,460,1632,358,331,806,1370,803,359,603,1101,491,805,238;39;F
15602;1089;41;F
15728;1632,460,225,1370,470,1200,801,1651,1089,921,238,331,803,476,491;25;M
15784;799,605,1266,370,1661;39;F
15905;1556,724,470,1632,460,331,225,1603,1200,1370,370,359,476,491,352;60;F
15914;1101,1724,921,1313,460,225,806,1200,370,803,933,1556,1355,476,491;35;M
15919;1355,548,921,331,225,1200,1370,1661,801,470,370,803,1556,476,1089;39;F
15949;803,603,476,538,1089,352,943,1200,331,491;37;F
15994;1606,1603,1370,470;43;F
16041;1661,470,803,359,933,603,853,491,238,921,352,1603,817,1089,548;34;F
16133;1266,1632,381,799,806,801,802,804,803,395,398,805,548,238,352;63;F
16293;1556,159,817,1370,1603,799,381,760,1606,331,1663,805,238,1089,604;44;F
16454;1556,1200,1603,460,358,331,225,470,370,359,933,476,491,1089,921;40;M
16504;370,921,352,1313,1632,460,1661,470,803,476,1101,548,1089,1200,225;29;M
16573;933,395,491,1709,921,470,1661,943,238,370,1632,359,225,476,460;33;F
16658;331,1606,760,358,460,933,1556,476,921,1632,1313,853,1101,491,548;25;F
16716;853,1556,933,470,331,460,225,1200,370,359,476,1101,491,921,352;36;M
16742;277;19;F
16893;806,1606,460,331,491,1089,1101,803,1632,358,225,1603,352,921,1556;28;F
16929;476,933,359,1266,460,225,1200;26;F
16992;604;32;F
17152;370,1108,359,933,1556,491,921,460,1200,1632,331,1101;24;M
17158;1632,1603,1200,802,605,803,277,1709,921,460,799,1355,476,1101,491;33;F
17215;1355,1108,1266,352;35;F
17356;921,238,1603,225,460,1632,331,1200,1661,370,1266,804,803,491,548;27;F
17479;352,1632,460,331,1603,1200,1370,943,1651,359,1556,395,476,238,1724;55;F
17527;921,491,1632,724,358,806,548,460,331,470,370,803,933,1556,1200;51;M
17570;1313,804,359,933,1089,1355,1556,1108,801,817,1603,381,331,760,1632;33;M
17577;352,1632,460,331,1603,1200,1370,943,1651,359,1556,395,476,1724,238;60;F
17748;460,358,225,470,370,359,933,476,491,921,352;43;F
17840;331,1200,1661,370,1556,933,476,1089;30;F
17870;358,1606,331,225,1200,1370,470,1651,724,933,1556,476,1101,238,1089;66;F
17884;159,1632,460,358,470,370,803,933,1556,476,491,921,1200,225,331;34;F
17957;1200,1108,370,803,933,1355,1603,225,460,470,359,1556,476,491,352;64;F
17989;921,1724,1709,476,1603,1313,331,1661,470,1266,933,1101,491,805,238;39;F
18104;460,331,470,933,1313,1632,1661,804,803,1556,806,225,1603,1200,476;41;M
18184;331,1556,476;53;F
18213;1606,1603,1200,1651,803,1556,603,476,604,760,1370,238,805,381,1661;43;F
18234;1355,1724;49;M
18340;225,1603,470,933,358,159,803,476,921;38;F
18359;1724,805,398,1313,1266,1709;42;M
18575;1632,460,470,370,1266,1651,1556,395,491,225,331,1370,1661;7;F
18593;1651;48;M
19082;1101,460,331,225,1603,1200,470,370,803,933,1556,476,491,1089,921;59;F
19381;1632,1313,460,358,331,1200,370,1108,359,1556,933,476,1101,921,491;33;M
19463;1200,1370,470,1663,804,1355,1101,1709,921,352,460,370,933,476,238;40;M
19556;331,806,1200,1370,470,1266,804,1651,803,1556,395,476,277,352,921;22;F
19640;358,760,359,1355,604;39;F
19709;1632,1313,803,1556,1101,921;30;F
19809;933,358,1606,225,470,1108,352,1089,1632,331,1200,724,1101,491,921;27;M
19846;1200,331,225,1603,370,933,476,491;35;M
19882;491,476,1556,933,803,370,470,1370,1200,806,1603,225,331,460,1313;64;M
19893;331,460,921,538,1101,724,1108,470,1200,225,1089,491,803,806;22;M
20055;1556,933,225,1313,460,358,331,1603,1200,470,803,921,476,491,1089;35;M
20253;1556,395,238,1370,331,460,225,1603,1108,803,933,476,491,352,921;32;M
20283;1603,806,359,1266,803,1556,933,398,805,238,1089,1661,802,1632;56;F
20420;933,476,238,1266,1370,381,921,352,398,359,1108,370,331,358,1632;30;F
20535;1632,331,225,1603,1108,724,1355,1101;26;M
20593;1556,603,476,491,921;44;M
20622;1632,1603,1200,1101,548,1089;23;M
20683;225,801,803,359,395,352,1632,1370,802,1651,491,238;23;M
20753;358,1709,460,225,1603,806,1200,1370,470,803,1556,331,476,491,921;34;M
20848;225,1200,1370,159,1661,804,1108,803,359,933,1556,476,398,921,352;32;M
20922;460,760,331,225,1603,1200,1661,801,470,803,359,933,1556,603,476;34;F
21058;358,359,476,921,1101,491;35;M
21364;476;27;F
21652;370,1266,724,933,476,1709,1724,921,460,358,331,1200,1108,359,1355;40;F
21654;801,159,1370,1603,1606,331,1200,802,803,933,1556,395,476,238,1089;23;M
21694;1200,470,370,359,1556,395,921,933,603,476,491,331,1603,803,352;35;F
21754;331,370,933,1556,603,476,491,921;27;F
21756;460,225,1603,1200,159,470,370,803,359,933,1556,476,491,921,352;35;F
21776;331,358,921,1089,1101,1556,933,803,359,1266,370,159,225,1313,1663;25;F
21799;460,1632,352,921,491,1101,331,225,1603,1200,470,370,359,1556,476;33;F
21887;238,538,724,803,370,1200,331,225,1370,853,491,1089;27;F
21899;1632,358,1370,801,370,603,1101,491,921;35;F
21916;491,476,1355,1556,724,359,803,370,470,225,460,1632,1313,1603,1200;85;F
21944;159,801,802,370,1651,803,359,1556,933,476,805,548,1089,1724,921;27;F
21967;370,470,943,817,1200,799,460,1556,1355;41;F
21980;225,352;53;M
22023;1632,1313,817,159,803,1101,548,352;36;F
22061;460,381,225,1200,159,1661,1266,804,1108,605,803,724,933,1556,1355;28;F
22169;1556,801,1661,331,1606,1313,1632,225,1603,1370,359,933,476,491,1089;43;F
22238;1089,491,476,603,1556,370,470,802,1661,1200,225,358,460,933;21;F
22291;801,225,1370,1661,605,724,603,805,238,538;24;F
22318;1313,225,1603,370,491;36;F
22328;803,370,1603,1200,1632,1313,460,225,470,359,1556,476,491,921,352;32;F
22365;1603,1663,803,359,1709,1724,352,225,470,1108,724,1556,476,1101,1089;41;M
22391;1313,460,1200,1661,359,933,1556,476,352;32;M
22400;1200,1370,370,1651,359,933,476,491,398,238,604,1724,921,381,1661;28;F
22404;538,1101,1556,605,1266,802,943,1370,804,1651,724,1355,805,238,604;39;F
22433;1313,370,470,460,331,1603,1709,225,1200,1661,803,933,1556,476,921;29;M
22491;1632,460,358,331,799,1200,1370,803,724,603,853,491,805,548,238;28;F
22561;804,801,1370,476,358,460,1632,225,1200,370,1266,1108,921,724,603;30;F
22598;1603,1200,1606,933,603,476,491,548,1089;24;F
22628;238,476,1355,803,470,460,760,331,381,799,1200,801,1556,603,491;30;F
22629;538;55;F
22670;395,398,1709,358,460,331,225,159,801,1556,933,476,548,921,352;39;M
22696;724,853,1355,1101,491,548,460,225,1108,803,933,1556,603,476,398;34;F
22706;1370,359,1663,806,331,1603,491,933,370,460,225,1200,470,476,921;33;F
22743;491,921,460,1606,331,470,370,933,548,1089;49;F
22845;1606,1651,933,1101,548,1632,817,1661,1266,1556,603,1355,921,491,1089;33;F
22900;853,476,603,1556,933,803,605,370,470,1200,1603,225,331,460;41;F
22926;1632,460,225,1603,359,933,1101,921,352,331,548,803,806,476;29;M
22952;1632,1313,460,358,225,1200,470,933,1556,476,238,943,1370,1651,395;39;F
22993;1089,359,1603,225,460,470,933,1556,476,1101,491,921,352,1313,1200;40;F
22997;760,604,491,476,933,1556,1266,370,470,1661,1200,225,331,460,1313;35;F
23008;1606,1632,460,331,225,1603,1200,1370,1661,470,803,933,1556,476,491;27;F
23030;806,803,1556,476,1101,398,805,1089,921;34;F
23032;853,1200,1603,1556,1101,921,1089,603,225,1632;30;F
23035;933,803,370,491,1089,460,331,225,1603,1556,476,921,1200,470;25;F
23128;277;55;F
23149;1355,1556,933,943,460,1313,225,1603,1200,1661,370,803,476;30;M
23198;277;20;F
23200;1313,1200,470,476;31;M
23231;724,1108,370,802,159,331,1632,460,225,1200,470,1556,476,491,921;33;F
23264;802,359,352,1355,370,470,460,331,933,1556,491,921,1089,358,476;37;F
23279;853,548,491,1101,476,1355,1556,933,370,470,1200,225,460,331,921;35;F
23314;724,603,853,491,238,548,352,1651,470,801,605,805,1200,1556,1101;28;M
23430;1603,1200,1370,352,359,1556,933,491,225,1632,1089;34;F
23520;605,802,806,225,460,548,358,1606,331,1101,1200,801,803,352,476;28;M
23635;1632,460,225,1603,1200,1108,933,476,491;35;M
23641;1556,603,491,238,1370,1108,803;35;F
23646;1200,470,1556,277,538,225,1089;44;M
23650;724,277,538,358,381,804,476,548,238,1632,817,1108,1101,398,491;32;F
23716;1603,1200,159,933,1556,603,476,805;30;F
23835;277,1355,724,803,1651,804,1266,802,398,538;42;F
23849;358,1661,1108,1101,1089,799,605,853,548;37;F
23855;159,460,331,225,1200,470,370,803,359,933,1556,476,491,921,352;29;F
23936;1370,1089;75;M
24056;277;57;M
24063;1313,476,1101,1089,921,352;27;F
24072;1556,1313,1606,803,359,1101,548,352;31;F
24092;806,1603,225,331,1606,358,460,1632,1313,1200,801,491,1089,921,352;29;F
24138;470,1724,1101,1355,1370,1603,1089,1709,1632,1661,933,603,805,548,921;21;F
24156;460,225,1663,370,933,476,1709,1089,921,1603,1200,470,1108,1556,491;39;M
24172;1108,1266,802,801,1661,943,817,1370,1200,1603,799,225,760,358,460;33;F
24191;225,799,1200,159,1661,801,803,359,933,1556,476,1101,1089,921,603;33;F
24533;817,548;37;F
24563;225,460,804,476,358,381,817,1370,943,1651,803,724,1556,1355,238;38;F
24588;352,358,470;30;M
24590;358,331,1370,1661,1556,804,277,1101,398,238,1089,538,1266,803,805;34;F
24606;1603,1200,159,470,370,1108,359,1556,476,1101,491,352,225,803,933;29;F
24676;817,1661,801,802,1266,1651,1108,605,724,603,398,1709,238,538,799;40;F
24785;1661,1200,1603,225,358,460,1313,159,370,803,933,1556,476,491,1089;36;F
24878;358,460,359,491,921,225,1313,352,1632,933,1200,470,1556,476,1101;27;F
24885;548,1709,359,1632,225,1603,1200,460,803,476,1101,238,1089,921;48;M
24908;1556,359,159,460,1632,358,331,1603,1200,470,370,476,548,1089,921;39;F
25026;1370,943,801,802,370,1651,1355,238,381,1661,803,603,805,1089,604;32;F
25048;1632,1313,760,1606,331,1370,1661,1266,476,491,398;43;F
25111;1632,331,803,1101,491,1089,921;30;F
25191;921,460,933,1101,491,1313,358,225,1200,470,1108,359,1556,476,352;42;M
25228;933,370,470,806,460,225,1313,1632,331,803,1556,921,1603,1200,476;52;F
25248;1266,760;35;F
25252;331,760;37;M
25429;799,548,1089,805,853,1556,359,803,603,802,801,159,1370,817,1632;24;F
25453;724,460,358,225,470,370,359,933,476,491,921;62;M
25478;548,1632,1200,470,933,1556,476,1101;55;F
25526;760,803,370,470,159,806,603,491,476,1313,460,358,225,1200,1556;32;F
25557;1724,921,1709,476,395,933,1200,331,225,1632,1606,1355,1101,238,1089;43;F
25756;760;47;F
25797;358,331,1603,1200,1661,802,370,1266,933,352,921,1089,476,225,470;36;F
25820;803,804,802,1556,238,805,1266,801,1603,381,331,159,277,538,352;36;F
26019;331,1200,724;25;M
26071;803,370,806,331,1313,1101,491,1355,933,1108,470,1200,225,460,1632;30;M
26175;1603,1632,460,1200,476,491,352;47;F
26670;803,1370,1603,331,1632,225,1266,491,398,1661;46;M
26696;1603,1606,460,331,225,1200,470,933,1556,476,491,921;40;M
27280;921,804,1266,470,1370,460,476,1632,225;37;M
27296;803,1556,1101,491,548,238;19;F
27410;1651,359,1355,1709,352,491,476,933,1266,1200,1603,331,238;38;F
27667;277,803,933,1651,238,1089,921,331,225,1603,1200,1370,1108,1556,476;42;F
27839;604,277,491,398,331,1663,1266,804,724,801,1603,1661,1101,1200,1108;39;F
27852;331,1661,1663,605,1556,476,805,352,799,225,1603,603,1101,238,1089;33;F
27853;799,460,804,548,1313,476,1709,238,352,358,760,331,802,1663,1266;35;F
27907;1370,331,1632,1661,1266,804,603,1355,1709,238,1724;46;F
28024;491,1709,1089,538,1632,460,331,806,1200,352,921,1724,1101,476,1556;27;F
28078;1556,1101,460,1632,1606,943,1651,238,1709,331,1603,1200,1370;44;F
28328;1651,1663;37;F
28416;760,1632,1266,1651,803,460,358,225,470,370,359,933,476,491,921;45;F
28706;724,359,352,921,225,331,460,470,476,358,1200,1661,1089;23;M
28813;1724,921,225,398,1709,1089;34;M
28850;460,225,1603,1200,370,933,1556,476,491;38;F
28865;331,548,1089,460,358,225,1603,1200,470,370,803,1556,476,491,921;54;F
28942;1632,1313,460,331,225,1603,1200,470,370,933,1556,476,491,1089;46;F
29029;470,370,1651,803,933,395,538,460,159,238,921,1200,476,491,398;35;F
29038;806,1603,331,460,1632,817,802,1108,803,933,1556,395,1355,476,1101;46;M
29040;470,802,801,1661,159,1632,1313,760,1266,1101,491,1089;27;F
29053;1632,476,1709,352,358,225,1370,802,238;38;M
29157;1603,225,1200,1370,943,1651,1108,933,1556,395,476,491,238,1089,921;43;M
29398;277;19;M
29428;331,460,1313,802,724,1355,1089,1724,921,1632,1370,1651,352,395,238;40;M
29434;225,1603,1200,1370,1661,801,470,804,803,1266,491,398,1709,238,1089;48;F
29467;395,1370,943,1651,238;44;M
29527;277;25;M
29531;1606,724,1355,1603,1370,159,803,359,1556,476,352,1632,331,238,1089;28;F
29622;1200,331,605,370,802,801,1632,1603,1370,1651,603,805,1709,1724,921;68;F
29647;1101,1556,803,370,159,1200,1089,460,470,933,476,921,358,225,1108;52;M
29673;277,1355,538;35;M
29727;603,476,398,491,604,921,470,817,1266,933,1556,238,1651,943,1370;33;F
29834;1651,1370;83;M
29895;921,933,1556,1632,1313,1603,1200,817,159,801,470,370,476,1101,491;29;F
29915;1108,359,538,381,225,1603,806,1200,470,1651,803,476,358,1313,460;25;M
29939;1651,1370;26;M
30045;1370,817,470,370,476,491,805,1089,801,605,1556,921,803,603,1101;27;F
30060;1370,1651;77;F
30078;1266,470,933,1556,395,476,1632,358,1663,359,352,1661;40;F
30089;803,806,933,370,225,921,476,359,331,1632,470,1101,1556;41;M
30117;1313,470,921,331,806,159,359,1089,352;38;F
30140;381,799,806,801,395,805,548,238,804,802,803,398;32;F
30143;943,1370,238,1651;80;M
30196;1370,943,1651,238;78;F
30252;603,395,1661,760,1370,398,817,943,1651,238;40;F
30308;1313,225,1200,470,359,933,1101,352;31;F
30486;359,352,460,1313,1632,804,1108,933,921,1603,1200,1556,476,1101;44;M
30668;1089;36;F
30729;548,538;44;F
30758;538;36;F
30841;352,1661,1200,933,476;35;M
30950;1200,1313,1632,159;47;F
31067;921,805,491,1355,359,1266,817,381,460,1632,225,799,1663,603,476;52;F
31097;1632,1313,331,225,1661,802,1266,853,1355,398,352,921,359,1108,159;55;F
31157;470,803,933,395,1101,1200,1603,225,331,460,921,359,476,491,352;33;F
31245;1101,805,238,1089,604,921,804,1663,470,1661,1200,225,331,1266,1108;35;F
31271;331,1370,943,1651,603,238;46;F
31298;358,1556,331,538,225,476;46;M
31355;1313,460,225,1108,359,933,1556,1355,476,491,238;33;F
31481;1101,1556,933,803,1266,370,1663,1661,1370,806,225,381,1313,352,1632;35;F
31568;352,225,331,159,1370,802,1266,1108,803,1556,603,1355,1101,805,1089;42;F
31615;803,370,470,159,806,225,358,460,1313,1606,331,1603,1200,1101,1089;26;F
31714;1370,1632,277,1101,538;53;F
31823;943,801,1651,359,491,1603,817,1266,398,805,238,331,1370,1661,803;48;F
31877;1313,460,331,225,1200,801,470,370,933,1556,476,491,921,1089;54;F
31914;1632,1313,799,817,603,853,538;51;M
31916;1632,1313,1603,470,370,359,933,1556,476,1101,491,1089,921;56;M
31952;225,1200,943,804,933,1556,476,1101,1089,238,805,395,803,817,1370;54;F
32013;1632,1200,724,1556,476,1101;42;M
32068;460,352,370,1266,359,1606,331,943,491,548,238,921;29;M
32106;370,1313,1632,1200,470,933,476,358,331,1603,803,359,1556,1089,352;35;M
32203;352;35;F
32206;1632,381,799,801,803,398,238;33;F
32259;331,724,1556,476,491;47;M
32290;381,799,806,801,802,804,803,395,398,805,548,238;32;M
32299;604,1606,331,225,817,943,1661,801,1663,1266,804,803,398,921,352;27;F
32302;460,358,225,817,1661,470,370,1266,803,359,724,933,476,491,921;26;M
32370;381,1313,760,331,799,1661,801,805,1632,1370,943,1651,853,1101,238;49;F
32384;1632,460,225,806,470,370,803,933,491,476;43;F
32442;1632,331,225,1603,1200,1370,921,398,491,476,1556,804,1266,470,1661;23;F
32671;603,802,605,277,548,1661,1370,331,1632,1603,1200,159,1108,724,538;27;F
32680;605,1661,1200,802,548,801,1108,724,921,159,277,1632,1101,538,331;27;M
32766;1200,1606,460,370,1266,1108,803,724,933,1556,476,491,1724,921,352;24;M
32778;225,921,1661;43;F
32795;921,1089,1709,491,803,1651,1266,1200,1632,460,1661,801,370;24;F
32822;470,1370,1200,225,331,358,1603,1661,803,1556,476,1101,491,238,806;40;F
32897;398,1101,603,933,724,804,1266,1661,817,1370,1603,799,331,159,1663;38;F
32952;491,548,1724,1632,460,331,1370,470,803,476,1089,225,1603,1200,1556;35;F
32977;1266,370,1661,817,799,1632,1370,943,1651,395,1355,805,238;66;F
33081;603,1355,476,805,604,538,370,470,1370,460,1632,1603,1200,803,1556;47;F
33100;1200,352,1556;45;M
33125;1632,358,1603,1661,801,802,370,803,805,352;51;M
33137;277;47;F
33202;460,225,1663,370,359,933,1355,476,491,1709,358,1370;29;F
33276;491,805,548,1089,921,803,395,1355,1101,538;14;M
33280;1651,238;68;F
33292;538;60;F
33293;538;14;F
33370;358,760,1606,331,1370,802,1266,395,603,1355,398,238,1089,159,1651;39;F
33443;1661,1663,804,358,460,352,331,159,1108,605,359,1556,476,1101,548;29;F
33448;538;33;F
33548;277,921,538,1313,1632,1709,933,804,470,803,603,853,491,805,548;66;F
33554;1266,370,1663,801,1370,225,760,381,1661,1108,804,359,1556,603,238;31;F
33594;1108,1101,460,331,1200,1661,470,370,1266,803,933,1556,476,491,921;38;F
33671;1313,802,1266,1651,803,476,277;65;M
33683;1603,1370,1661,1663,605,1355,1632,225,799,724,1266,1108,277,548,538;45;F
33707;1313,1603,359,933,1556,1101,491,1632,358,331,225,1200,1370,802,476;45;M
33749;460,1108,933,603,803,370,1200,538,225,238,1632,1556,1101,470,476;30;M
33758;921,476,460,225,1370,1661,370,1556,1724,358,1603,470,359,491,352;44;M
33840;398,805,238,1089,538;53;F
33847;724;44;M
33884;225,1603,470,370,803,724,933,1556,476,1101,491,358,331,1200,1089;35;M
33915;1632,760,817,1651,603,476;69;M
33990;1101,724,331,381,1266,805;53;M
33997;277;25;F
34021;460,358,331,225,806,1200,1370,817,1108,933,1556,603,1355,476,238;45;F
34129;538,470,1370,225,460,1632,1606,331,1603,1266,804,359,395,1355,398;52;M
34145;805,1089,921,802,1632,460,225,1200,1661,1266,359,724,476,352,538;44;F
34163;460,358,1200,476,491,1651;53;M
34164;470,359,933,603,476,491,1724,921,352,460,358,225,1603,1200,1651;51;F
34200;460,1370,1355;30;M
34226;933,1108,1651,943,1370,1200,1603,225,331,460,1313,1556,395,476,238;13;F
34256;1313,460,225,1200,370,476;34;F
34257;1661,470,803,395,1556,817,1200,921,1632,1603,1370,801,491,238,352;46;F
34258;1632,1313,1200,943,370,238,352,760,225,1661,801,1108,1556,491,476;36;M
34282;933,1724,460,225,1200,1556,476,491,921,352,1603,331,358,1709,1089;38;F
34284;1661,1632,358,1200,370,1266,933,1355,476,1101,491,1709,921,1724,352;43;F
34305;943,470,370,803,1200,225,1108,1651,359,1355,476,921,352,1709,1724;36;M
34404;225,1603,1370,802,470,1266,933,921,1200,1108,803,1556,476,238,538;36;F
34417;1606,760,1313,804,1724,370,1651,803,398,238;31;F
34429;804,1556,805,548,1089,604,921,1603,817,802,1266,476,331,1661,470;32;F
34453;359,1663,1661,943,1556,1266,1370,1200;18;F
34470;1200,331,460,1101,1089,470,370,359,933,1556,491,1632,803,225,476;40;F
34474;1606,225,1200,470,370,1556,538,1603,476,921,331,1266,1355,491,1089;50;F
34563;803,460,1200,603,1089,921,1632,331,225,1603,470,370,476,1101,491;30;F
34566;802,1603,1370,370,476;59;F
34609;1108,605,359,933,395,1355,476,1101,491,398,1709,238,1089,921,803;14;M
34620;806,1661,1266,803,491,398,805;43;F
34753;1651;52;M
34774;159,1556,603,398,921,802,352,804,358,799,370,1108,359,491,604;32;M
34819;538;59;F
34823;331,1200,470,933,1556,921,1313,358;29;M
34846;370,470,943,1200,225,358,460;30;M
34885;1606,1632,460,1200,359,548,1089,604,352,538;61;M
34949;817,1370,806,1606,1632,358,331,225,1603,1200,470,933,1556,476,491;32;F
35166;1370,1651,395,238;49;F
35222;806,803,359,1101,491,398;40;F
35248;817,1661,803,538;60;F
35313;799,1651,724,603,548,238,1632,1370,921;33;F
35323;159,370,470,1200,1603,225,331,1632,799,1556,853,476,491,238,921;46;F
35349;801,358,225,331,1603,1200,470,803,476,1101,921;35;F
35362;724;44;M
35397;804,605,724,603;35;F
35452;1313,460,358,225,1370,470,370,1651,803,476,1101,491,238,921;19;F
35527;817,238,395,853,805,943,1370,1651,605,799,806,1661,1266,804,548;48;F
35611;1661,1556,803,470,933,352,921,1101,476,1632,331,225,1603,1200,159;42;F
35655;805,799,806,1200,1370,817,943,1661,1266,804,1651,395,398,548,238;12;M
35687;943,1370,238,1651;36;M
35708;476,548,238,470,491,1089,1606,1603,1556,921,1632,331,370,933;28;F
35712;806,1370,943,817,1661,1266,804,1651,724,1556,395,398,805,548,238;20;M
35734;853,806,1370,817,943,1661,1266,804,1651,605,1556,395,398,805,238;57;M
35746;398,548,538,352,943,238,1370,1651;76;F
35778;1632,1313,1370,159,1661,1663,359,476,1101,491,548,921;32;F
35780;238,1370,1651;67;F
35893;1606,395,225,803,1200,159,460,1632,1108,933,1556,476,491,921,352;70;F
35898;1370,760,1632,370,491,1709,470,1200,1313,460,225,921,476,933,1663;42;M
35915;1606,225,470,803,1556,395,1632,331,1603,1200,370,933,476,491,1089;55;F
35968;933,470,225,460;32;F
36048;381,801,398,1661;38;F
36084;1661,1663,277,331,1370,943,802,1266,1651,395,398,548,238;54;F
36170;1355,352,548,1632,1313,460,358,1606,331,225,1603,1200,803,1556,476;35;F
36199;159,470,370,359,933,476,1089,921,352,331,1200,1556,1101,491,238;35;M
36230;760,1661,1663,370,1266,398;37;M
36263;1266,1108,803,359,933,1556,476,491,238,921,352,331,225,1603,1200;42;M
36335;1556,933,803,470,1200,225,460,331,1370,943,1651,476,491,238,1089;50;F
36336;358,225,1200,933,1556,476,491,1089,921,352;38;M
36366;1651,1556,1101,1709,803,1108,1266,1663,1661,1313,1603,225,1632,476,352;37;M
36388;604,1724,921,605,803,359,724,603,1101,238,1661,801,1266,1651,352;38;M
36418;225,801,370,1108,1101,491,921,1724,359,476,1200,331,460,1709,352;34;F
36508;159;71;F
36513;381,1266,1355,277;43;M
36532;331,159,359,1101,1089;68;F
36542;381,1355,277;40;F
36558;538;43;F
36562;358,1603,803,1089,538;40;F
36566;381,1266,1355,1089,805,277;16;M
36572;1370,943,1651,395,238;61;F
36577;1663,470,943,1370,1606,460,331,225,1603,1200,724,933,1556,921,238;43;M
36578;1089,331,1632,460,1606,225,1603,1200,470,359,933,476,352;64;F
36587;802,805,538;38;F
36756;921,352,359,1370,1603,1632,460,225,817,1200,470,933,1556,476,491;51;M
36849;921,943,1632,1313,460,225,1603,1200,470,370,933,1556,1355,476,491;56;F
36920;1632,1108,1651;26;M
36934;225,1200,331,359,853,548,921,352,1556,1651,724,603,476,1089,1709;42;F
36961;476,331,1603,370,1556,395,491,1709,225,1200,1651,359,352,548,238;45;M
37075;933,1266,1663,801,159,331,358,460,1603,1200,803,476,491,548,1089;28;F
37233;1632,1313,225,1200,802,1651,933,476,1101,491,1089,921,1709,238;56;F
37294;1370,943,370,1266,1651,605,603,1089,238,805,277,476,1355,724,803;41;F
37319;817,803,395,1101,1089,1724,1370,1661,802,724,1355,805,238,538;40;M
37320;853,277,1101,398,238,1089,921,548,538;42;F
37382;1266,804,398,803,1355,538;37;F
37397;370,1266,803,359,724,476,491,1632,331,1603,802,1108,805,1089,538;45;F
37401;1266,538;49;F
37446;538;53;F
37468;1355,1556,933,370,1603,225,358,460,1313,1200,470,603,476,1101,491;33;F
37484;548,538,159,1200,225,331,460,1313,370,724,359,476,491,921,352;31;F
37488;817,806,1370,1200,225,331,1632,1266,1108,803,1556,476,1101,238,538;43;F
37493;538;38;F
37543;1632,331,460,476,358,225,1370,1603,1200,1556,398,238,1663;32;F
37560;1651,803,933,395,1089,331,1603,1200,1370,370,1266,1556,476,491,538;63;M
37578;460,358,331,225,1603,1200,933,1556,476,491,921;38;M
37612;605,358,724;41;F
37615;1632,331,370,476,277,491;57;F
37660;238,1651,1370;40;F
37681;806,1200,1370,470,804,803,933,1556,476,491,398,331,1266,1089,538;36;F
37716;1313,470,370,1266,933,1556,476,1101,491,1709,1370,943,1651,395,238;38;F
37755;1370,1556,1266,1200;23;F
37820;331,921,1724,460;26;F
37888;1266,370,470,1603,760,1632,331,225,1200,1661,803,1556,476,1089,921;35;F
37903;1709,359,370,470,806,1313,460,358,1200,803,933,1355,476,1101,491;22;M
37934;370,933,238,225,358,460,803,1556,1661,159,1370,1603,381,331,476;36;M
37943;853,1355,1108,803,933,1556,603,1101,1089,225,238,921,476,358,470;43;M
37951;933,1632,225,1603,1089,1313,1200,470,1108,476,352;38;F
37979;1606,331,1661,370,1108,238,1089;20;F
38112;370,603,491;29;F
38122;225,1200,159,470,1108,359,933,476,491,238,921,370,803,1089,352;29;M
38166;1632,1661,933,1556,1089,604,352;51;M
38208;802,1266,538,331,1661;42;F
38270;1556,476,358,1603,803,805;51;F
38331;760,331;36;F
38403;803,476,238,352,1200,331,460,358,225,470,370,359,933,491,921;26;F
38498;1200,1370,801,1266,1108,359,1556,476,548,1089,352,1632,1661;35;F
38503;1603,1200,801,359,933,1101,1089,921,817,1661,370,803,1556,603,491;22;F
38541;225,159,1603,1355,491,1089,1632,1266,277,1556,395,1101,476,238,538;47;F
38550;352,359,1651,370,331,1370,491,1709,1724;83;M
38580;803,470,352,1101,476,1556,159,460,358,331,225,1603,491,1089,921;33;M
38587;1603,806,1200,1556,921,238,933,803,225,331,1370,801,370,476,491;29;M
38591;943,921,548,491,476,1651,802,806,225,460,1200,1661,470,370;23;F
38602;460,1632,358,331,1200,470,370,1266,803,933,1556,476,277,1101,491;28;M
38615;1556,1632,1313,460,331,225,1603,1200,817,801,1651,359,476,238,352;69;F
38658;933,1709,604,1724,921,352,605,359,1370,801,1266,1355,476,398,238;38;M
38752;1370,1661,1266,1651,803,476,277,491,398,1108,724,805,548,238,538;43;F
38851;548,238;41;M
38856;1603,1606,358,1200,1556,476,921;38;M
38949;159;37;F
38957;159,724,1556,1101,491,538,352;30;F
38980;538;39;F
39024;460,331,225,817,370,1556,476,491,548,238,1089,1632,1603,1200,470;32;F
39131;1632,225,460,358,331,799,1200,159,370,933,1556,476,491,1089,921;35;F
39345;1603,801,1108,803,359,933,1556,1101,921,352,1313,331,476,491,1089;64;F
39355;225,1101;37;M
39375;359,605,1108,1651,1661,159,1370,1200,1632,331,225,1603,802,933,1556;60;F
39426;803,538;54;F
39537;1266,804,398,538;46;F
39653;805,238,921,352,331,225,1370,817,802,370,605,803,359,476,1101;39;F
39694;1370,943,1651,238;78;F
39700;238,1101,395,1556,1266,1663,1661,817,1370,331,802,803,538;38;F
39740;1370,1200,1266,1556;60;M
39752;1632,1370,1355,476,277,805,548,238,352,538;57;M
39803;538;44;M
39845;1632,331,225,921,352,491,476,370,470,801,1200,1603,1606,460,1313;38;F
39920;225,1200,802,470,370,395,491,1632,1603,1370,933,1556,476,1101,238;40;F
39996;921,476,801,460;30;M
40056;277;55;F
40075;460,1606,331,225,1200,817,943,802,470,370,933,1556,603,476,491;27;F
40136;1313,460,331,225,1200,1266,933,1556,476,1355,491,1101,238,1089,921;45;F
40163;1370,1651;72;F
40164;921,1313,460,331,225,1603,1200,470,370,803,933,1556,476,491,1089;23;F
40192;724;47;M
40213;1101,548,604,1370,943,1651,238;68;M
40224;1556,476,331,1606,1632,460,225,802,359,1370,943,1663,1651,395,238;47;F
40244;1632,799,1200,1370,817,370,1651;63;F
40491;370,359,933,491,1089,921,1632,470,331,603;34;F
40502;238,604,921,1108,1101,1200,803,603,476,1313,460,799,1661,802,1266;13;F
40503;1370,943,1651,238;78;M
40520;1370,1200,1266,1556;32;M
40572;1632,803,1101;40;F
40612;225,1200,470,724;52;M
40641;605,1556,603,476,1101,238,921,460,358,943,802,1108,803,1266,1661;9;M
40655;1370,943,1651,395,238;83;F
40710;395,1370,943,1651,238;84;F
40729;538;38;F
40826;358,1266,804,605,1709,604,1724,724;45;M
40866;933,352,491,1101,358,1632,331,225,1603,1200,470,1108,1556,476,921;38;F
40897;225,1266,1651,724,476,238;60;M
40920;1370,943,1651,395,238;51;F
40969;1370,943,1651,395,238;26;F
40980;1200,1603,225,331,1606,460,1313,358,1370,370,1556,476,491,1709,238;20;F
40996;1632,1370,1663,1651,803,724,1556;34;M
41007;1089,604,921,358,724,1556,1355;25;F
41044;491,460,225,806,470,370,1556,1663,331,1200,1370,803,359,1709,352;25;M
41058;538;44;M
41068;370,470,1603,225,1200,803,476,491,538;48;M
41160;1370,1651,395,238;64;F
41265;724;19;M
41267;359,603,491,548,476,460,331,1603,1200,470,933,352,225,358,803;28;F
41297;352,359,1556,933,476,460,358,1200,225,370,470,491;26;F
41367;1661,470,1108,933,603,491,1632,1556,476,1101,548,238,921;31;M
41444;1370,943,1651,395,238;68;F
41464;1370,943,395,1651,238;70;F
41544;1632;31;F
41755;331,225,460,1313,1603,1370,801,470,1266,1651,933,1556,476,491,238;69;F
41859;1370,943,1651,395,238;55;F
41951;460,1632,331,1603,1370,370,803,1101,491,1709,1089,801,1651,359,352;34;F
42032;853;51;F
42056;933,1200,225,460,1313,1632,331,1603,159,470,370,803,359,476,491;33;F
42071;1266,359,760,1313,1632,1101,1556,724,476,331,933,806,548,803,277;43;M
42186;801,1556,933,1709,1313,460,331,1603,225,1200,470,476,921,352;37;M
42265;331,1603,370,804,1632,225,1661,802,359,933,491,805,1709,921,1089;22;F
42319;760,331,225,1200,933,491,1313,460,1661,1651,1370,943,395,476,238;51;M
42325;359,933,921,1089,853,470,331,460,1632,1200,1556,476,1101,548,803;45;F
42367;933,921,352,238,476,395,359,1651,470,1661,1370,1200,225,460,760;47;F
42404;238;78;F
42468;1632,381,799,806,801,802,1651,803,395,398,805,548,238,604,352;62;F
42473;603,538;44;F
42484;1266,1108,803,724,1556,1355,277,491,538;48;F
42518;460,605,802,801,331,1603,1370,1661,1266,603,1101,398,1089,921,538;43;F
42548;331,460,370,1266,1108,1355,238,1724,352,1313,1370,1709,1632,943,1651;47;F
42555;1632,806,381,799,801,802,804,803,395,398,805,548,238,604,352;67;M
42591;538;13;M
42597;1661,1632,381,799,806,801,802,804,803,395,853,398,805,352,548;35;F
42649;933,370,470,460,358,331,1603,802,1266,1108,603,476,491,1089,538;45;M
42666;799,1661,1370,331,470,1266,604,225,1200,476,491,238,1089,921,370;39;M
42781;724;43;F
42948;370,470,1603,225,460,331,1370,159,491,1089;47;F
43009;1661,1651,933,476,491,1724,358,331,1266,804,1355,1101,1709,1089,604;44;F
43087;1313,460,225,1200,470,359,933,1556,603,476,1101,491;26;F
43114;724,352;41;F
43118;1632,1603,352,460,358,225,470,370,803,359,933,476,491,921;37;F
43167;1632,1606,225,1370,943,724,1556,853,476,1101,491,238,1200,548;44;M
43194;1089,1632,1651,476,238;19;F
43290;460,358,225,470,370,803,359,724,933,476,491,352,921;2;M
43366;1632,370,933,460,358,331,225,803,359,476,491,921;37;M
43442;1266,1101,538;38;F
43503;1661,801,1355,331,370,921,460,225,1200,470,803,933,1556,476,491;27;F
43512;803,395,398,921,370,460,1606,331,225,1603,470,933,1556,476,491;23;F
43584;460,1606,331,225,1603,1200,802,470,370,1651,603,476,491,1089,921;53;F
43605;1200,806,933,803,370,470,1370,331,460,1632,476,491,238,1089,921;32;F
43621;470,370,1266,804,933,476,277,491,538,1200,1108,803,1556,1355,1089;34;F
43676;921,1724,238,1200,359,1606,1603,1370,804,1651,603,476,1709,352;42;F
43735;1370,1632,1603,370,1651,1556,476,1355,1101,1089,1661,853,491,548,921;46;M
43859;352,225,1606,460,1200,943,470,359,1632,1370,370,1651,476,491,238;22;F
43919;806,803,1355,538;43;F
43936;358,225,1603,1200,1661,801,470,1266,1108,803,933,1556,1355,476,491;42;M
43974;538;41;F
44001;538;11;M
44011;1313,352,538,921,476,1556,359,1200,225,801,470,370,1266,1108,803;19;M
44013;538;8;M
44064;806,803,538;46;M
44076;331,1632,1313,460,225,1603,1200,1370,370,1556,933,1355,476,491,921;37;M
44146;802,1266,358,1108,724,1101,398,538;40;M
44151;1632,381,799,806,801,802,804,1651,803,395,398,805,548,238,352;33;M
44182;331,803,933,491,1724,1313,460,358,470,1108,1556,724,476,238,921;25;M
44219;381,799,806,801,802,1651,804,803,395,398,805,548,238,604,352;1;F
44296;1313,460,225,1200,470,933,352,476;45;F
44298;806,1603,760,460,358,225,1200,801,370,1556,603,1101,491,548,921;26;F
44299;331,159,803,1556,603,476,238,352,921,491,359,370,470,1370,1606;30;F
44314;538;14;F
44339;225,1200,470,370,359,933,476,491,921;47;F
44348;806,538;12;F
44354;933,803,331,358,1603,159,921,225;28;M
44392;1632,1200,803;31;F
44395;1101,921,817,1603,225,331,1313,1632,358,1606,1200,943,853,491,1089;41;F
44410;1556,398,805,604,921,804,1266,225,460,1603,1200,1370,159;64;F
44417;604,921,1603,1200,370,1266,1651,476,491,1661,238,331,1313,1632,760;35;F
44599;395,603,1355,604,1089,238,398;45;F
44610;1200,460,358,225,470,359,724,933,1556,476,491,921;24;M
44680;1370,943,1651,395,238;72;F
44691;805,548,604,853,603,1108,804,1663,331,358,806,159,803,1089,352;42;F
44713;921,476,603,803,1606,460,331,225,1603,159,470,605,933,491,1089;39;F
44722;806,358,1313,1632,460,225,1200,159,470,476,1101,491,1089,921,352;26;F
44759;225,370,491,805,921,358,460,1603,470,933,1200;35;M
44781;1606,159,352,1556,370,460,331,225,1603,1200,470,933,476,491,921;36;F
44788;460,358,225,1603,1200,470,370,933,1556,603,476,491,1709,921,352;32;F
44796;1313,358,331,225,1200,1370,1556,1101,1709,238,1089,476,460;33;M
44797;603,1266,1200,381,1606,331,1603,159,470,370,804,1556,476,491,1089;62;F
44810;225,370,724,1101,921,538,460,331,159,1355,491,1709,1089,1724;29;F
44821;1632,1370,817,1266,358,225,801,1355,1661,802,1663,804,805,238;39;F
44838;1313,1556,491,1724,1632,1089,352,460,1606,331,225,1603,1200,476,921;46;F
44867;1313,1603,370,933,491,921,1632,331,225,1200,1370,470,359,1556,352;29;F
44938;1661,370,803,1089,1313;28;F
45048;1663,225,1603,159,1661,1089,352;31;M
45060;159,933,548,358,331,1200,1370,470,370,1724,460,1313,1101,1089,801;20;M
45081;1632,460,331,225,1603,806,1200,359,933,1556,1355,476,1101,921,352;44;M
45082;604,398,760,799,1651,238,1661;43;F
45123;352,921,1556,933,803,370,225,460,1313,1370,476,238,1632,1200,470;34;F
45127;225,1313,817,802,1108,724,476,604,1632,331,1603,1661,1266,238,1089;45;F
45132;1556,933,1651,470,801,1200,1606,1632,331,159,370,1101,491,1089,921;28;F
45244;724;43;F
45253;225;45;M
45257;370,724,491,921,460,277,470,1200,225,358,1632,1556,476,1101,398;40;F
45280;1313,1632,358,331,395,238,760,943,1370,1651;40;F
45287;225,470,1266,1355,806,803,548,538;40;F
45428;470,1556,395,491,238,1089,1724,1632,460,225,370,1651,476,1709,921;36;F
45456;331,1370,801,370,359,933,1556,853,476,548,352,1632,1661,1651,238;32;F
45484;724;40;M
45499;359,803,1651,1661,1370,1355,1556,1632,331,1603,1200,1108,352;62;F
45521;806,1355,476,921,352,1632,1606,1200,1661,370,805,238;39;F
45535;1632,1606,331,225,1603,1200,159,470,933,1556,476,491,1089,921,352;43;F
45600;491,1266,803,933,1355,352,921,1556,1089,1661,1200,1603,1606,1632,1313;42;F
45655;1632,1606,331,225,1603,1200,470,933,1556,476,921,359,491,1089,352;44;M
45696;1632,1370,1651,395,238;66;M
45743;1556,933,476,921,370,470,803,1603,225,331,358,460,238,1089,491;27;M
45779;358,359,724,476,1370,1108,238;38;F
45804;476,1556,933,1200,1603,1313,460,358,225,352,359;34;M
45932;331,1313,460,225,1603,1200,470,370,359,803,1556,476,1101,491,921;25;F
45958;225,381,1606,1313,1632,331,1266,803,359,1556,1101,491,805,1089,352;34;F
45991;1355,1663,603,805,604,225,1632,358,799,1200,159,804,359,1101,548;48;F
46042;760,1603,817,1651,1724;52;F
46082;1632,331,1603,1200,159,801,370,804,359,933,1556,476,491,921,1089;26;F
46192;1632,1370,1651,238;71;F
46396;1266,1108,476,352,1556,803,1603,331,225,799,605,724,603,805,1089;44;F
46421;548,359,470,460,1632,1313,358,760,225,1603,806,1370,1661,802,1266;28;F
46432;1606,358,460,1266,804,1651,605,359,395,225,331,806,803,1089,398;62;F
46451;933,853,1101,604,352,159,1370,1200,225,491,370,943,331,1606,1089;43;F
46575;1651,603,805;40;F
46637;331,352,933,803,370,1603,460,225,359,1556,470,1200,491,921,476;47;M
46646;1603,1200,803,548,352,1632,225,470,370,359,933,1556,476,491,921;29;F
46661;331,470,1556,395,476,352,358;37;F
46826;1313,225,470,1089,238,548,853,1606,1632,331,1101;26;F
46867;943,395,1651,238;17;M
46879;1355,1101,491,1089,352,1661,801,470,933,1556,603,476,805,548,921;27;F
46882;1370,943,395,1651,238;17;M
46891;238,331,1632,358,1603,1663,803,1200,470,370,359,933,476,491,921;50;M
46922;460,331,225,1603,1200,1370,943,470,1651,724,395,603,476,491,238;54;F
46989;359,470,460,724,1266,331,1632,159,1108;18;F
46994;604,352,398,277,1556,799,470,370,1266,933,476,491,225,1200,921;36;F
47010;476,491,398,805,1709,548,1101,1556,1370,1200,1603,225,331,460,760;43;F
47102;1101,1651,225,1370;37;M
47177;1200,1603,225,331,460,1370,1651,933,1556,395,476,1101,491,238,1089;43;F
47181;853,491,1709,1089,921,352,1101,359,460,225,1603,1200,802,476,238;45;F
47221;358,1200,470,370,933,1556,476,1101,491,238,352;24;F
47233;1313,370,803,491,921,470,802,1200,225,460,1556,238,1089,476,1101;15;M
47255;943,817,1313,460,358,1606,331,225,1603,1200,1108,803,1556,476,548;44;F
47259;1200,1108,803,359,1556,395,1355,476,491,358,1370,933,1101,921,352;48;M
47267;1632,1606,225,331,1370,1661,801,470,370,1651,476,491,238,1089,921;27;F
47283;801,1200,1603,225,460,331,1606,1313,470,370,603,476,491,1089,921;34;F
47304;1370,159,801,470,370,804,1108,359,1556,603,476,491,238,1089,352;36;F
47308;395,548,1370,331,760,1632,817,1661,370,1108,724,476,491,238,352;27;F
47329;801,331,1632,460,225,1200,470,370,933,1556,476,1101,491,921,1089;43;F
47358;806,1200,1370,943,370,1651,476,1101,491,1724,921,395,1556,933,803;26;M
47434;225,1200,277,921,538,476,1556,933,801,331,1313,460,358,159;36;M
47491;277;56;F
47502;460,331,225,1603,1200,470,1663,370,803,359,724,933,476,491,921;42;F
47526;1603,470,1709,1651,1663,1313,1266,1108,724,1101,398,238,760,331,225;31;M
47621;1556,799,358,460,603,491,1709,238,604,352,921,476,470,1200,225;24;F
47640;853,548,1663;63;F
47684;352,548,358,331,370,1266,603,476,491,238,1089,921;34;F
47747;1200,1370,1266,1556;76;F
47770;159,359,225,1200,1661,801,470,370,605,933,1556,476,491,1089;24;F
47806;352,1313,1200,159,1663,724,1556,548,921,1603,1661,470,803,277,1089;21;F
47844;933,1556,603,491,1724,352,921,538,460,225,1200,803,476,1101,1709;29;M
47936;603,277,476,398,548,1089,538,352,470,1313,331,159,359,724,491;30;F
48024;491,1089,921,1313,1355,1556,933,359,803,370,470,1603,1606,331,724;18;M
48076;225,1603,470,370,803,1556,476,1101,491,1089,921,159,331,460,1313;38;M
48177;1370,817,1651,853,548,238;35;M
48234;1556,933,470,1200,1603,225,331,460,370,803,359,1101,491,805,921;47;M
48270;358;40;F
48282;933,398,352,225,1370,802,804,724,1556,476,491,805,238,921,538;42;F
48303;1651,605,803,853,491,805,548,604,921,538,1632,724,1556,1089;58;F
48304;1709,1603,358,1632,1313;46;M
48306;1108;41;F
48348;1313,1370,817,933,1101,238,331,159,801,370,803,921,352,491,1089;30;F
48375;724;41;M
48485;225,1200,159,470,370,1266,803,1556,476,491;29;F
48580;470,1556,603,1355,476,352,358,159,1724,331,370,803,359,491,1089;29;F
48753;370,802,1108,476,491,1632,159,1661,225,238,331,1603,1089,538,921;33;F
48948;1200,1370,470,370,1556,1101,805,331,159,801,605,476,491,238,921;31;F
49034;470,1603,225,358,803,933,921,476,370,359,1724,1089,460,352,1200;32;F
49083;277,352;63;F
49168;359,460,1632,1313,331,225,1603,1661,470,370,803,1556,1101,491,921;38;F
49240;1632,1370,817,802,1651;50;F
49273;943,817,1603,1313,1632,460,225,1200,1370,1661,470,370,1651,476,491;78;F
49334;1089,1606,331,159;19;M
49392;352,491,460,331,225,1603,1200,470,370,803,359,933,1556,476,921;70;F
49413;352,921,933,1089,1709,491,1101,1603,331,1724,225,476,460,803,359;22;M
49437;803,460,331,225,1603,1200,470,370,359,933,1556,476,491,921,352;29;M
49509;1370,943,1651,395,238;73;F
49537;370,1556,1603,1200,352,921,803,358,460,1632,225,470,933,476,491;32;M
49538;1632,277,1266,398,805;70;F
49580;1556,803,1200,806,1313,460,331,225,1603,159,470,476,1101,491,921;36;M
49590;358,331,799,1200,605,724;50;F
49668;1370,943,1651,395,238;77;F
49676;359,603,491,1089,921,352,1632,225,1200,803,933,1556,476,1101,724;23;M
49756;1370,1651,238;10;M
49863;1370,1651,238,352;45;M
50047;1370,943,1651,395,238;68;F
50061;1355,491,538;39;F
50065;1606,331,1603,159,370,1108,803,359,1556,853,476,491,548,1089,352;41;F
50070;1370,943,1651,395,238;72;F
50080;1663,1651,933,1355,476,1709,1101,1089,238;26;M
50113;238;19;F
50177;1606,331,1089;45;F
50182;358;39;F
50202;1603,470,370,491,352,1556,476,921,1089,1101,603,460,1606,331,1200;25;F
50229;1200,1370,1266,1556;46;F
50266;352;51;M
50314;1355,1603,921,806,1556,1313,460,225,1200,470,370,803,933,476,491;43;F
50380;1108,1606,1603,1370,159,803,359,1556,476,1101,1089;29;F
50394;460,331,225,1370,1661,470,370,1651,1108,933,395,476,491,238,921;40;M
50438;605,1200,1101,921,491,476,1556,933,724,803,370,225,159,359,352;32;M
50508;225,1603,1200,933,476,1101,1089,921,1632,331,799,605,853,491,548;34;F
50509;358,760,1370,943,1661,801,802,1663,1266,1651,933,395,277,398,238;54;M
50534;358,1606,331,159,370,1108,933,1556,1355,476,1101,491,1089,921,1603;38;F
50549;1313,460,225,1200,470,370,803,359,933,1556,491,1724;50;F
50564;1313,460,225,1603,806,1200,470,370,803,933,1556,1355,476,491,921;42;M
50685;1370,802,1663,1651,548,238;57;M
50725;238,1370,1651;69;F
50729;395,398,1313,1101,921,352,460,331,1603,370,359,933,476,491,538;32;F
50845;1632,238,1266,802,801,1661,470,370,395,1089;20;F
50848;803,1632,1606,331,277;51;M
50948;1266,1556,352,331,799,359,1355,476,491,548,1089;61;F
51130;548,538,352,1632,460,1606,1200,159,1101,238,921,331,1603,1556,1089;67;F
51146;470,933,1313,460,358,225,1603,1200,1370,802,370,1108,1556,476,921;40;F
51190;470,491,238,921,538,1556,724,359,605,1108,370,1661,760,358,604;37;M
51282;331,806,803,933,1556,476,491,1089,921,352;69;M
51446;225,159,470,803,853,538,1200,1370,370,933,1556,476,352,1603,491;45;F
51498;460,1606,331,225,1603,1200,470,370,803,933,1556,395,476,921,491;53;M
51675;460,225,1603,1200,817,470,370,803,359,1556,476,491,548,1089,921;34;M
51732;760,1370,1661,802,1266,804,1651,603,1355,277,805,398,604;7;M
51786;1661,1651,1108,933,225,1606,1663,491,921,352,1603,359,1556,1101,548;47;M
51867;358,491,460,225,476;32;M
51971;1632,806,817,370,803,933,1556,603,476,1101,491,805,238,1089,921;25;M
52045;1632,1313,460,331,802,470,1266,804,1651,1556;39;F
52082;921,358,225,933,277,352,548,476,331,1606,1632,1603,1200,803,1556;53;F
52120;1632,331,225,1603,1200,470,370,803,359,933,1101,491,921,476,352;43;M
52146;1606,331,225,1603,1200,470,933,1556,603,476,491,238,1089,921,352;44;F
52194;1632,799,605,603,853,476,1101,491,921;41;F
52306;460,358,331,225,806,470,370,359,803,933,476,491,921;87;F
52314;1200,470,370,803,933,1556,603,277,491,1709,1632,358,225,1603,476;39;F
52464;1266,1663,1200,806,1603,331,225,470,804,352,359,1556,476,491,1089;36;F
52469;1355,1632,460,331,1603,802,1266,804,359,1101,1709,1089,604,352,921;76;F
52514;1632,1313,806,1603,760,1663,1709,921,476,460,225,470,370,491,1651;26;M
52520;225,352,460,1632,1313,799,1370,802,470,370,724,603,476,491,1089;42;F
52561;491,395,933,1313,370,604,1370,1651,1266,1632,1603,801,1556,238,1089;21;F
52675;604,804,799,159,460,358,225,470,370,359,724,933,476,491,921;31;M
52676;604,1313,760,331,1603,1661,801,370,1266,359,603,1355,476,398,352;34;F
52797;921,476,359,370,1724,1603,1089,470,225,358,460,352,803,933,1200;35;M
52845;352,358,331,370,359;38;M
52852;1108,803,933,238,1089,1200,159,470,225,1370,1266,724,1556,476,277;46;F
52939;331,225,1603,1200,470,370,803,933,1556,1355,476,491,548,1089,921;35;F
52940;358,331,225,1603,470,476,1089,921;37;M
52985;1632,1313,331,1603,1200,933,1556,460,225,476,921,491;42;M
53000;802,803,1556,395,603,331,538,1603,370,804,476,491,805,548,238;45;F
53080;1603,1200,370,1651,395,491,1089,1313,1370,803,933,476,1101,238,921;38;F
53102;1313,460,803,476,921,491;32;M
53127;352,921,470,1603,225,460,1313,370,803,491;66;F
53158;370,803,359,921,352,1313,460,225,1200,1661,470,1556,1355,476,491;37;F
53180;225,470,921;25;F
53233;1556,603,491,1632,460,1313,358,225,1200,1108,933,476,1101,548,921;34;F
53344;460,799,1661,1266,803,359,352;32;F
53363;460,1606,331,225,1200,470,370,803,933,1556,476,491,1089,921,352;29;F
53687;1200,491,1709,921,352,1313,470,1556,1101,933,358,476;30;M
53831;1089,370,1632,460,331,1370,1651,603,1355,476,398,805,1709,238,1724;54;F
53885;331,1603,1370,1651,359,238,1089,352;62;F
53925;359,370,331,470,1101,476,1556,933,803,1603,1313,352,1200,225,358;31;M
53995;1313,358,225,1200,476;48;M
54022;381,817,538,805,724,603,853,799,1370,1661,1651,548,238,1089,1632;21;F
54050;1370,277,801,370,1651,225,331,460,1632,1556,395,476,491,238,921;30;F
54108;460,1606,331,225,1603,1200,1370,470,370,1556,1709,1651,476,491,1089;82;F
54114;1108,724,1556,1101,398;24;M
54150;331,943,801,1651,1108,359,1556,395,1101,491,1709,238,1089,921,1370;26;F
54156;760,1266,1089,604,1724,358,159,1108,476,1101,491,921;27;M
54158;358,460,1632,225,1603,1370,470,370,1651,933,603,476,491,238;31;F
54230;1632,225,1556,395,476;36;M
54259;1556;53;F
54369;395,1101,1661,817,605,1089,238,1556,803,1370,1200,1603,331,1606,1632;26;F
54373;225,238,476,724,1266,1651;53;F
54596;1370,817,943,1266,804,724,1556,853,476,604,352,1661,359,1101,398;35;F
54614;460,1313,358,370,476,491,1089,921;23;F
54700;1313,460,1606,331,225,1603,801,470,359,933,1556,476,1101,1709,921;31;M
54807;1370,238,1101,476,159;31;F
54869;1632,1661,802,804,1651,1556,1355,476,277,1101,491,548,238,604,538;44;F
54950;225,806,470,1556,1355,476,1200,331,358,460,491,1632,943,238,1651;39;M
54955;331,159,1661,1108,605,724,548,1089,538;37;F
54974;359,1663,1661,1603,1266,1089,804,799,604,603,476,398,381,358,331;23;F
55073;381,1200,1266,724,1355,277,538,1632,331,1603,1661,803,1556,1101,352;58;M
55148;1313,1370,1661,1663,1266,724,1556,1355,277,398,604,538;33;F
55161;331,159,370,605,724,603,277,1101,398,805,1089;51;F
55165;225,470,370,1266,359,933,603,476,398,921,352,331,159,491,1089;44;M
55206;1200,470,370,359,933,1101,548,238,225,1108,803,724,476,491,352;36;F
55233;802,470,1266,1108,803,359,933,1556,603,1101,491,1089,921,358,331;42;M
55252;603,1101,921,460,331,225,1200,370,803,359,933,1556,476,491,352;42;M
55270;491,1313,1632,460,225,1603,470,370,359,1556,1101,1089,921,352,331;44;F
55285;1266,538;35;F
55299;724;41;M
55422;460,331,1603,476,491,805,1089,921,538;45;F
55432;352,921,1709,491,1101,359,370,470,225;30;M
55476;470,804,395,398,1632,1313,358,331,801,802,803,933,1556,603,476;38;F
55479;1632,1200,470,359,1556,1101,352;57;M
55489;159,370,1266,1089,331,1603,806,1200,470,803,933,1556,476,491,921;34;F
55554;159,359,1089,352,331,943,1266;31;F
55665;1200,1661,1663,1266,804,1651,1108,359,1556,1355,1101,398,548,1089,352;59;F
55731;1632,1313,225,470,1556,476,921;29;M
55746;803,470,225,1313,460,331,1603,1200,370,1266,933,1556,476,491,1089;79;F
55778;460,1200,1370,801,802,1101,1632,225,817,1661,603,476,491,238,921;33;M
55817;1632,358,225,470,370,359,933,1556,476,491,1089,921;28;F
55847;370,352,1724,1556,1632,460,358,225,470,803,359,933,476,491,921;18;M
55868;806,1313,460,760,331,225,1603,1370,1661,804,1266,476,1101,398,921;46;M
55869;605,803,603,277,460,358,225,470,370,359,724,933,476,491,921;29;M
55891;352,921,805,359,470,491,460,225,1603,1200,370,803,933,1556,476;36;M
55910;724,933,1556,1101,921,352,1661,1663,1266,476,398,604;39;F
55916;1313,159,331,1606,358,460,225,1200,470,803,359,933,476,491,921;43;M
55949;1370,817,1651,724,1556,805,225,331,460,804,238;30;M
55953;1632,1606,331,1603,806,1200,943,159,470,370,1266,933,1556,395,1089;32;F
56002;803,933,1355,491,1724,921,370,470,358,1313,460,1556,331,476,1101;33;F
56005;1101,359,1651,1661,1632,921,802,225,331,760,358,460,1313,370,470;36;M
56016;1101,370,225,1632,460,1663,476,921;45;M
56188;1266,853,1101,398,548,921,538;74;F
56224;1266,853,398,548,1089,921,538;66;M
56271;603,359,370,225,358,460;30;M
56280;921,460,331,1370,943,1661,370,1089,225,799,817,801,491,548,238;25;F
56329;358,1603,1370,1661,1556,1355,476,238;28;M
56364;802,1651,238,1101,803,358,460,225,470,370,359,933,476,491,921;36;F
56392;1603,921,1632,460,470,370,803,1556,476,491;66;M
56420;806,1313,460,225,1603,1200,470,370,803,933,1556,1355,476,491;42;M
56532;470,538,1556,1355,1101;36;M
56651;225,1632,548,1370,1603,331,460,1313,1200,1556,238;24;M
56693;548,1603,1200,817,1370,159,1651,1556,476,1632,358,1101,921,238;28;F
56699;358,799,1266,804,398,604;34;F
56712;460,225,470,1266,1108,803,359,933,476,491,921,1089,352,358,331;29;M
56786;1651;65;F
56798;1724,1089,331,359,1651,476,491,1709;60;F
56805;352,398,476,1355,603,359,1266,370,801,1661,1603,331,760,1313,604;35;M
56823;724,470,1709;24;M
56830;1603,460,1606,331,225,1200,159,470,370,1556,476,1089,921,538,1370;20;F
56841;760,801,1266,804,398,805,238,604,538,603,1355,277,921,724,1661;53;F
56844;470,1651,803,933,395,1556,238,921,225,1603,370,1200,603,476,491;39;M
56852;538,921,476,933,724,803,470,1200,225,331,460,1632,1606,1101,1089;60;M
57006;1370,352,370;43;F
57197;1663,1266;43;F
57229;225,1200,1661,933,476,1101,921;27;M
57253;921,1632,460,225,1200,1370,943,470,370,1651,476,1101,491,238,1355;36;F
57269;225,331,358,1200,470,1663,1108,1355,476,933,1556,1089,1313,1632,1101;73;F
57374;398,548,604,760,1603,1661,802,395,476,238,921,352,225,1370,1556;44;F
57431;370,1606,1313,460,331,225,1603,1200,470,933,1556,476,1101,1089,921;29;F
57453;1603,359,395,921,460,331,225,159,801,1663,470,803,476,491,352;33;F
57471;853,604,802,470,370,804,1266,352,1556,476,1313,1661,1709,238,1724;45;F
57521;1200,1603,1632,802,370,1266,1556,476,277,491,398,238,604,921,538;44;F
57614;225,1632,460,1370,370,1663,1651,804,603,1355,476,491,398,805,238;54;M
57647;1632,159,803,1556,395,921,802,1200,1603,358,1266,352,1101,1709,238;27;F
57699;805,1089,604,538,1632,331,159,1266,1651,1108,603,1355,398,1709,548;53;F
57735;470,1661,225,331,548,1709,491,1266,370,1651;63;F
57739;724;43;F
57759;1370,159,1108,605,933,491,238,921,538,760,1661,1266,804,476,398;38;F
57888;331,225,1603,806,1200,370,803,933,1556,395,476,491,1709,238,1089;33;F
57923;1313,460,331,943,1370,359,933,1632,358,1603,1200,370,476,491,921;45;M
57978;1603,921,476,1200,1632,331,359,1101,352;43;F
58048;806,1603,799,331,358,460,1313,225,1200,470,370,476,491,548,921;24;M
58080;1663,1266,359,933,398,921,352,1632,331,1603,476,491,1709,1089,1724;23;F
58150;460,358,1606,225,1661,470,370,395,1089,476,1556,933,1200,1603,331;42;F
58173;799,1266,605,724,603,398;45;F
58176;1313,1603,470,1556;36;M
58215;724;53;M
58218;460,225,1603,1200,470,370,359,1556,603,476,1089,921,352;29;F
58355;724;20;M
58361;331,225,1370,1661,801,470,370,1108,476,1101,491,1709,238,1724,921;30;F
58367;358,1313,1089,238,548,853,1556,933,943,460,1632,352,921,476,603;28;F
58370;1606,1661,801,605,603,853,476,805,548,1089,1724,352;42;F
58373;331,1370,802,370,1651,1556,395,476,491,238;41;F
58511;460,331,1603,1200,1370,1651,1101,352;48;M
58633;799,1632,1200,1370,943,159,470,1108,933,1556,476,1101,491,548,238;50;F
58754;724,470,1089,1200,933,1556,358,225,1603,1661,370,476,491,921,359;41;F
58796;352,238,491,359,1370,801,921,225,476,1200,331,1603,1632,1651,460;32;F
58844;1603,802,1266,359,724,1709,238,1089,538;52;M
58896;1603,358,1200,476,1101,491,921;36;F
58914;1313,801,359,921,1101,1355,331,1632,1603,1200,1709,1651,1089,1724;50;F
58977;225,806,370,803,933,1355,1089,921,460,331,1603,1200,470,1556,476;31;F
58979;1632,1313,370,1266,804,491,1651;58;F
59046;358,460,225,1200,359,1355,491,1709,1724,921,352;30;M
59068;806,1200,370,359,1709,352,921,476,1355,933,470,225,1313,491,1724;37;F
59200;605,603,853,277,398,548,538;51;F
59210;460;29;M
59244;331,1603,1661,724,1556,238,1632,159,603,491,1101,1089;39;F
59278;1313,470,724,921,460,358,331,1101;30;M
59283;1266,605,491,398,724;36;M
59309;460,331,806,1370,803,724,1556,277,491,538;47;M
59378;358,331,359,724;41;M
59412;805,1709,238,1724;68;M
59466;921,1632,1663,1266,603,238,358,225,1603,1200,1370,159,803,476,548;40;F
59495;1651,1266,1663,1661,1632,331,1603,1370,804,933,1556,395,238,1089,352;52;M
59501;225,359,476,1200,1603,358,352;31;M
59545;1266,538;42;F
59561;1661;55;F
59595;1370,803,724,933,1556,395,603,476,1101,491,805,238,1089,921,538;45;F
59596;943,1370,799,460,1200,605,921,491,476,603,1556,933,470,1603,225;51;F
59604;331,1266,1355,476,1101,491,538;45;F
59661;1632,1101,352,921,491,476,1556,933,359,370,470,1200,1603,225,460;30;M
59726;933,370,331,358,460,225,1603,1200,470,803,1556,476,491;34;M
59747;1370,1663;34;F
59827;1266,933,853,398,604,476,358,799,605,381,724,603,1355,805,538;52;F
59860;1556,352,1603,1200,470,803,476;34;M
59882;460,225,470,370,476,491;21;F
59983;724;27;M
59991;1089,1556,359,803,605,1370,1603,799,225,724;45;F
60009;491,460,1313,802,1663,359,933,1101,604,1724,538,1632,1709,548,1089;50;F
60075;460;29;M
60142;470,1603,225,331,1313,398,921,476,1355,460,381,603;33;F
60201;370,491,921,1313,460,225,1603,1200,470,1108,803,933,1556,476,352;36;F
60241;460;24;M
60281;358,1603,802,1108,476,1101,548,538;37;F
60300;1606,470,803,933,921,1632,331,225,1603,1200,370,1556,476,491,1089;37;F
60452;1313,803,1355,1709,538,352,1089,805,1556,933,359,470,225,460;60;M
60484;460,358,225,1603,1200,802,370,476,1101,491;37;F
60488;1200,1661,470,370,605,359,933,476,491,548,352,1632;65;M
60510;381,921,491,1355,1556,803,1632,1313,460,225,1200,470,370,476,1724;43;F
60562;801,724,352,1606,1603,1370,470,1651,933,1556,603,238,1089,921,538;23;F
60598;1313,1108,1355,1101,538;29;F
60641;159,1370,1632,358,1606,331,1651,933,603,1603,1200,1556,238,1089,921;31;F
60657;460,225,470,370,933,1556,1101,1313,1603,1200,921,476,491,352;42;M
60760;331,1370,1661,1663,1266,804,1651;45;F
60828;817,1603,225,460,358,1200,159,370,1266,803,476,491,398,921,1089;39;F
60875;933,238,1200,1089,1632,331,1603,370,1266,803,1556,1355,476,277,491;71;M
60908;1101,1724,370,470,476,491,1089,921,1370,1603,225,1556,803,460,1632;30;M
60918;352,370,470,1661,159,331,1632,225,760,358,1603,801,1266,359,491;28;F
60925;1370,943,1651,395,238;73;F
60951;804,943,225,159,1661,476,799,1266,605,805,604,538;40;F
60966;921,352,491,933,359,803,370,802,159,460,1313,225,1200,1556,476;22;M
60987;802,1724,921,1632,1313,358,331,225,1603,1370,803,359,491,1089,352;35;F
61065;803,1200,359,1556,238,1709,1724,921,1632,331,1603,933,476,1089,352;62;M
61219;1313,1632,470,359,352,1556,1603,1200;43;M
61224;805,933,370,470,1370,943,1651,395,238;61;F
61235;1556,933,352,1101,460,225,1200,370,853,476,1089,921,802,603,548;26;M
61258;806,1313,491,476,603,1556,933,370,470,817,1200,1603,225,460,1632;36;F
61280;921,1709,1632,1313,1606,331,1200,803,359,1556,476,1101,1089,352;34;F
61315;1313,460,358,331,225,1200,159,1663,1108,359,933,476,1101,1089,352;19;M
61360;358,460,760,225,1200,1661,470,370,1108,359,1556,933,476,1709,921;48;M
61361;1101,1651,1661,943,1370,352,921,238,476,1556,803,1266,470,1200,225;43;F
61416;1603,225,933,1724,460,358,331,1200,470,370,359,476,491,921,238;33;F
61494;603,724,803,605,370,804,1651,1108,359,1355,398,799,604,805,1266;47;F
61637;491,476,933,1556,803,370,470,1200,806,1603,225,460,358,1724,921;71;M
61671;491,921;29;M
61715;476,1724,358,460,225,1603,806,1200,470,370,803,1556,933,491,921;71;F
61718;1632,460,225,1200,359,476,491,921;28;M
61741;1370,943,1651,395,238;55;F
61764;1661,803,476,238,352,395,1651,1266,801,1370,1603,760,1632,358,1089;28;M
61771;1313,358,817,805,1709,548,1724,921;45;F
61772;1661,159,381,1313,853,604,238,603,805,1606,331,801,476,352;49;M
61774;1370,943,1651,238;27;F
61783;460,331,225,1200,159,470,359,933,1556,1355,476,491,1089,921,352;47;F
61789;1632,460,1313,358,806,933,359,476,548,921,352;29;M
61802;1200,806,1603,460,921,491,476,1556,933,359,803,225,1606,331,1089;53;M
61825;1101,1606,1632,358,331,1603,1200,1370,1651,933,1556,491,238,1089,352;46;F
61853;359,395,1101,491,238,921,352,476,331,460,225,1370,1200,1556,1709;34;F
61859;460,1632,491,238,1089,921,538,1200,159,370,605,803,724,1556,277;34;F
61881;943,1632,476,921,1603,1200,470,370,1556,491,352,460,225,1370,238;54;F
61884;605,853,921,352,460,331,225,1603,1200,817,470,933,1556,476,491;45;F
61926;1651,933,1556,395,603,1101,491,1709,1724,921,352,460,331,1603;36;F
61935;370,803,470,1603,225,460,331,1200,476,491,921,352;42;F
61951;1606,1603,933,352,1108,605,803,724,1556,603,476,491,398,805,1089;48;M
61965;470,359,933,1355,1089,921,1709,491,1101,476,370,1200,1603,225,460;28;M
61978;352,921,1709,1101,1355,933,470,225,331,460,1200,476,491,1089,1724;45;M
62007;1661,801,802,1663,933,1556,548,921,1632,1606,331,225,1200,476,1089;23;F
62031;398,1101,801,1370,1632,460,225,1603,1200,470,803,933,1355,476,491;31;F
62064;460,331,225,1603,1200,470,803,933,1556,1101,491,1709,238,921,476;43;M
62101;460,802,1663,359,476,921,1603,1661,548,352,331,1606,1632,1556,1089;29;F
62106;460;31;F
62132;853,476,491,805,604,538,352,460,331,1266,605,724,1355,398,1089;28;F
62139;359,1556,395,853,491,352,460,1603,1200,933,476,1089,921,331,225;40;F
62155;491,1556,1108,370,470,1603,225,460,1313,1200,359,476,238,352,921;38;F
62163;460,804,724,933,1101,491,1089,921,470,1661,225,1313,1200,359,476;33;F
62174;1200,1370,470,1663,1266,933,1556,476,1101,491,398,548,238,921,352;42;F
62229;1556,933,370,1200,225,331,1606,460,470,1266,491,1089,398;34;M
62234;1632,460,358,1606,331,225,799,1603,159,802,470,1663,370,1266,1108;35;F
62291;1313,1200,1370,1266,803,476,1663;39;M
62319;1355;27;F
62330;1200,1556,491,724,460,225,470,359,933,476,921;66;M
62354;760,331,381,817,1355,398,460,1661,804;35;F
62358;933,1101,491,548,604,1632,1313,460,358,760,1200,817,1266,476;30;M
62360;760,1632,1606,1603;36;M
62409;352,476,1355,159,1603,1370,817,1663,1108,1101,398,238;40;F
62446;491,538;37;M
62562;1266,370,470,806,225,460,1089,724,1603,817,803,1556,476,491;47;F
62661;538,1108,724,476,1101,491;27;M
62689;370,1200,1603,159,1266,1651,1355,1089,398,238,476,395,1556,1370,331;43;F
62704;460;19;F
62743;1313,1632,331,225,1663,476,921,491,1709,358,1200,470,803,1556,1101;32;M
62761;225,1313,460,921;31;M
62848;331,470,724,805,352,1200,1108,933,225,370,1556,476,491,1089,921;54;F
62849;331,225,799,1200,1663,1266,804,605,359,1355,476,491,1709,604,724;43;M
62909;352,1724,476,933,359,1313,1632,358,1603,370,1101,491,1709,1089,921;27;F
62917;1108;46;F
62946;359,943,806,381,331,760,799,1603,1200,1370,804,1651,1108,803,1709;40;F
62998;1632,460,1603,370,470,476,1101;40;M
63016;370,1651,724,933,921,1370,225,460,1200,605,1556,476,491,805,238;43;F
63024;1632,760,1200,1661,801,470,476,1101,921;54;F
63047;1313,460,331,225,1603,1370,1556,476,1632;52;M
63086;225,1200,470,370,359,933,1556,476,1101,491,238,538,352;66;F
63204;491,604,1266,1651,605,395,853,805,921,799,1370,603,398,548,238;48;F
63237;159,724,1089,1101;20;F
63309;1606,1661,605,853,604,1370,381,358,802,1663,1266,1651,359,398,238;33;M
63350;1200,1603,460,1632,331,803,933,1556,476,491,548,1089;61;F
63374;1355,352,460,1313,358,331,225,1200,370,933,1556,476,491,1089,921;34;F
63448;1603,460,1355,1101,538,331,225,370,933,1556,476,491,1709,1089,1651;66;F
63468;470,460,817,1603,799,225,1632,1370,1651,605,491,398,548,238,1089;49;M
63495;921,1089,238,491,1101,476,1556,933,1651,370,801,1370,1603,358,331;56;M
63635;853;71;M
63673;1101,921,803,1266,1661,1632,358,331,381,1370,801,802,1355,476,805;46;M
63676;1606,1370,331,1603,817,1661,470,933,603,548,921,352,1200,238,1089;34;F
63690;460,358,1089,1603,331,760,1632,801,370,1651,803,933,476,491,238;36;F
63794;802,1200,806,1603,225,358,460,1313,331,159,1661,1108,724,1709,1089;34;F
63817;1603,1632,331,799,1370,802,1266,804,605,603,1355,398,805,238,538;51;F
63859;225,1200,603,933,370,1089;21;F
63895;1632;33;M
63946;1313,803,933,352,1724,476,1556,225,331,358,460,1709,1101,491,921;24;M
63954;1370,225,381,358,1313,1632,1661,802,470,1663,370,352,1709,398,460;35;F
63983;933,1556,395,801,943,1370,1200,225,358,1603,1661,1266,603,476,238;42;F
64000;1632,358,331,1603,470,370,359,1355,476,491,805,1709,238,921,352;35;M
64004;921,460;61;M
64008;801,603,604,331,1632,1603,1200,1370,1651,1108,803,724,1556,395,238;33;F
64031;817,470,1266,933,398,604,921,352,359,603,853,491,548,1101,1661;40;F
64081;1313,460,358,225,799,1200,933,476,491,921;45;F
64099;381,943,1101,460,1606,1313,370,803,1556,1355,476,352,331,359,491;27;F
64161;331,1200,1089;37;F
64173;1313,460,358,331,1603,225,1200,370,359,933,476,491,1089,921,352;32;M
64176;470,370,359,395,1101,491,921,460,1370,476,1709,238,1724,352,1651;27;F
64292;225,1200,470,803,359,933,1556,921,352,476,491,358,331,370,1089;40;F
64317;159,358,817,460,1632,331,225,1603,1200,1370,802,470,803,1556,476;31;M
64334;225,1200,817,1661,470,370,933,476,491,1089;24;M
64413;1313,921,538,1355,943,1200,225,460,1651;39;F
64429;1101,1313,1108,1355,538;63;F
64445;460;34;M
64534;359,352,1313,358,331,1603,470,370,933,1556,491,476,1200,225,1089;34;F
64560;1603,381,460,358,1606,331,225,370,1355,476,491,398,1089,1724,921;38;F
64609;1108;12;F
64635;1108;16;M
64684;799,1266,398,604,760,804,538;24;F
64686;1108;48;M
64689;460,1606,331,225,470,370,803,359,933,1556,476,1101,491,1089,921;57;F
64778;1556,1603,803,933,921,460,225,1200,470,370,359,476,491,352;29;M
64792;359,1663,460,1313,1370,1661,352,1108,358,331,476,1200,225,1603,921;42;M
64876;921,491,359,370,358,1632,331,225,1603,1200,1370,470,933,1556,476;32;F
64894;1651,802,1370,331,238;38;F
64931;538;63;F
64933;1661,806,358,760,460,1606,225,331,476,1089,1556,491,398,1108,370;42;M
64969;370,1266,359,1556,603,548,1089,225,1603,1200,1661,470,476,491,921;30;F
64976;460,225,1200,470,359,1556,476,491,352;35;M
64980;358,460,1101,476,1651,1370,1200,1603,331,1313,1632,352,238,1089;28;F
64982;933,225,331,817,803,1556,395,603,476,1101,491,548,238,921,370;26;F
65049;1651,370,943,1313,460,331,225,1603,1200,1370,470,359,933,476,238;64;M
65059;460,1606,1200,159,470,1556,331,802,370,1108,803,933,476,491,1089;25;M
65067;1200,921,476,1556,933,724,225,331,1606,1603,1370,159,470,238,1089;39;F
65108;943,1108,359,395,476,548,358,1603,806,803,1556,1101,805,238,352;49;F
65192;817,943,801,470,1651,605,359,933,1556,603,853,460,331,238,1089;28;F
65212;933,1200,225,331,358,460,1603,470,370,804,1108,803,1556,491,1089;41;F
65265;476,1089,352,331,381,1266,1108,1355,398;33;F
65282;1313,799,159,805,548,238,398,1355,804,1651,1632,1661;43;F
65285;491,548,238,604,921,538,1632,817,1661,1266,359,603,352,803,225;66;F
65305;460,358,225,470,370,359,724,933,476,491,921;51;F
65397;853,933,724,370,470,943,1200,460,225,491,548,238,799,1370,1651;50;F
65431;1632,799,801,802,603,853,1101,548;39;F
65438;1355,460,331;34;M
65441;1313;37;M
65541;921,1556,1632,1606,331,225,803,359,476,352;27;M
65589;933,395,476,805,921,1632,1606,801,370,853,1101,491,548,1089,352;35;F
65852;1355,1313,460,358,225,1603,1200,470,803,724,491,352,476,1089,1724;28;F
65901;225,460,358,1661,802,370,1266,804,1108,359,933,603,398,548,604;28;F
65957;277,805,1089,921,538,1632,1370,943,1651,605,1556,395,1355,476,238;65;F
66017;1355,491,921,538,1632,358,225,1603,1200,470,803,724,476,1101,1089;33;F
66021;460,331,225,1200,470,370,803,933,1556,476,277,491,921,538,352;36;F
66024;460,1606,331,225,470,359,724,1556,603,1101,921,352,370,538,802;38;M
66025;1661;14;F
66038;1603,1200,476,225,470;39;F
66074;1632,460,1606,331,225,1603,1200,470,370,476;12;F
66079;1313,760,1370,1663,359,1556,476,491,352,724;53;M
66090;1661,817,1603,799,358,460,225,1200,370,933,476,1101,491,548,921;50;F
66098;1724,1709,352,921,476,1355,359,1651,1108,225,1200,803,370,470,943;33;F
66103;603,470,370,159,1370,225,1313,933,724,331,358,460,359,238,1089;50;F
66105;491,1661,159,1370,358,460,1632,1556,804,331,1603,470,1266,803,1089;42;F
66120;1709,238,604,943,1370,1663,1651,491;39;M
66126;460;47;F
66129;1266,358,470,943,1200,331,760,370,1651,1108,1556,476,491,238,352;38;F
66149;1101,398,805,604,538,352;67;F
66159;460;17;F
66162;460;14;F
66164;1632;64;F
66186;1370,460,225,1200,370,1651,1108,803,359,1355,476,1709,1724,921,352;3;F
66217;1556,476,1101,1200,460,358,225,1632,331,1603,1089,921;41;F
66222;1603,1200,159,470,933,603,476,331,225,1370,1632,370,1101,491,238;27;F
66249;460,225,1200,470,370,1651,1108,359,1355,476,1709,238,1724,921,352;;M
66273;933,491,331,476,1724,352,921,370,359,1632,460,358,225,1603,1200;46;F
66302;603,476,225,331,1355,1709,352,1724,358,1200,1663,803,1556,491,1089;28;M
66340;460;48;M
66358;460,225,1200,159,470,724,476,1101,491,1089,921,352;51;F
66400;921,352,225,460,358,331,1200,1266,1651,359,853,398,805,548,1709;51;M
66570;1089,1632,460,225,1200,470,370,803,1556,476,491,1709,238,1724,921;60;F
66637;359,933,1556,1355,476,491,1089,921,352,1606,331,225,1603,1200,1101;37;M
66664;476,395,1556,359,1651,370,470,943,1200,1603,225,1370,803,491,238;36;F
66671;803,1200,470,352;31;M
66697;476,398,921,352,802,1661,806,1266,803,491,538;40;F
66703;817,803,1101,548;44;M
66923;760,804,853,805,548,1606,331,799,817,159,603,238,921;38;F
66978;1556,1603,1370,1661,476,352,1632,1089,1200,370,1108,1355,1101,491,921;38;F
67035;358,381,225,806,1200,470,370,803,359,933,1556,476,1101,491,538;37;F
67052;225,476,491,1200;38;M
67057;352,603,933,1632,331,225,1200,470,370,476,491,1089,921;33;F
67125;352,381,799,806,801,802,804,803,395,398,805,548,238;35;M
67165;802,470,370,1651,933,476,491,238,1632,331,159,801,1101,921,1089;35;F
67183;1556,1370,1200,159,1632,1606,331;54;F
67196;331,1101,491;33;M
67230;460,1603,1089,1556,225,358,1313,1200,921,470,370,803,933,476,491;31;M
67235;470,1200,1603,381,331,1606,358,1663,460,1313,806,802,803,538;42;M
67241;1632,1603,359,1556,331,806,803,352,538;14;F
67253;225,1200,470,370,1266,803,933,1556,1355,476,491,398,352,921,538;11;F
67322;395,1101,604,381,1661,1663;36;M
67324;1632,331,1603,1370,943,1651,933,1556,395,476,491,238;43;F
67383;370,933;61;M
67409;358,460,331,225,1603,470,370,803,933,476,491,921,352;33;M
67428;1200,238,1101,1355,460,358,225,470,370,359,724,933,476,491,921;34;F
67452;352,921,1101,476,1556,359,801,943,1603,1200,803,933,802,1370,806;26;F
67471;1370,817,1651,359,853,238,352,921,805,1556,460,225,799,1603,802;73;F
67519;1603,460,1200,1556,1101,352,1313,225,806,803,359,603,476,921;30;F
67674;1603,817,1661,802,1266,921;62;F
67729;1651,370,395,225,159,359,476,1632,548,1101,331,238,803,806,943;30;M
67801;803,1108,804,1661,1200,460,1632,225,1370,802,1266,1556,476,238,538;32;F
67803;943,470,395,358,801,225,1200,1556,476,1632,460,1603,1370,238,1651;62;F
67892;921,491,476,603,1556,724,933,359,803,1108,225,460,358,1200,352;39;F
67938;1370,943,1651,395,238;79;F
67954;604,352,1313,460,802,370,1266,238,1661,1603,801,470,603,491,805;35;F
68003;1313,225,1200,470,933,1556,395,476,491,548,921;31;F
68047;1606,760,331,1603,470,370,359,933,1556,476,491;24;M
68106;370,470,225,1603,1200,460,491,604,921,853,603,1266,943,1370,760;49;F
68161;1313,395,1089,358,331,225,1603,1370,470,1651,1556,476,238,921,352;52;F
68175;1661,1108,1101,1313,1603,1200,1266,476,1709,921,1632,802,1651;63;F
68226;370,470,1603,225,358,1632,331,1200,159,1089,921;37;F
68228;491,933,1556,803,370,470,1200,806,1603,225,460,358,1724,476,921;36;F
68235;1313,460,331,225,1603,1200,470,370,359,933,1556,476,491,921,352;33;M
68254;724;35;M
68302;1370;69;M
68323;225,1651,395,331,943,1556,921,1370,817,370,1266,803,476,491,238;41;F
68325;1370,943,1651,395,238;86;F
68334;605,799,802,805,159,1108,277,225,331,1663,476,853,1632,817,548;32;F
68365;1603,1200,470,1266,803,805,225,1663,1108,1556,1355,476,1101,491,921;38;M
68453;1200,1603,1606,331,476;42;M
68472;331,358,460,470,1266,1108,803,933,1101,238,921,1370,1556,476,491;46;M
68549;225,1200,470,933,476;44;F
68569;1370,943,1651,395,238;72;F
68598;1606,331,470,933,476,491,1089,921;36;F
68633;1632,159,470,370,1266,359,933,1556,603,476,491,1709,1089,1724,921;65;M
68661;225,1313,760,1200,1661,470,370,803,933,476,491,1632,460,802,724;28;M
68731;331,1556,1101,803,1632,1603;41;M
68846;358,1108,724,277,491,538;24;M
68874;1370,603,238,1651;70;F
68932;803,370,225,460,358,331,806,1200,470,933,1556,476,491,538,352;42;F
68941;1709,1355,724,470,806,1632,460,225,1200,801,370,803,1556,476,491;30;M
68997;806,1200,470,370,1266,803,359,933,1556,1355,476,1101,491,538,352;9;F
69020;1603,1200,370,359,491,352,476;37;M
69024;1313,358,801,370,359,853,491,1709,1089,352,476;24;F
69190;1632,460,358,470,370,359,933,491,331,225,1200,476,921;35;F
69214;370;50;M
69222;1313,331,1603,1200,817,1661,470,370,933,1556,476,491,548,352;50;M
69228;548,476,470,1200,225,358,1632,1313,370,603,1101,491,238,921,538;32;M
69268;352,724,1556,1355,277,805,538;39;M
69303;470,370,460,331,1603,801,1266,803,933,1556,1355,476,491,398,921;29;M
69377;1632,1313,1101,538;76;M
69449;238,395,1370,943,1651;53;M
69462;331,1606,358,1200,1370,804,1651,395,159,801,1556,805,1603,1661,538;47;F
69555;933,801,817,358,352,1632,331,225,1603,1200,1556,476,491,921,1089;34;F
69600;395,1101,491,225,1603,1200,817,359,933,1556,476,921,352,331,1089;36;M
69618;331,1603,470,933,1556,476,1101,491,1709,1089;26;M
69661;491,1101,476,1355,470,1661,159,1603,358,1632,1370,1266,1651,1556,1089;24;F
69700;538,1603,806,803,724,933,476;39;F
69847;359,1632,1313,460,225,943,802,1266,1651,803,1556,853,491,238,1089;45;F
69880;724;32;M
69941;1556,476,1603,1632,331,803,1089;32;M
70016;476,1101,921,352,1632,1313,760,331,802,603,491,1709,548,238,1724;31;F
70058;225,799,1200,817,470,370,1266,359,933,853,476,1101,491,921,352;37;F
70082;806,1200,817,159,470,370,933,805,491,548,331,1661,801,603,476;32;F
70096;1632,470,370,460,331,225,1603,1200,802,1266,603,1355,476,491,921;31;M
70124;370,605,359,933,395,1101,491,398,1709,1724,352,1313,1661,804,1355;41;M
70134;1200,1370,470,370,1651,803,359,933,1556,603,476,491,238,921,352;36;F
70197;1101,805,921,1632,1603,1200,1370,159,370,1651,760,803,476,491,1709;34;F
70198;352,921,395,476,1556,370,1200,225,760,331,358,470,1266,1108,359;43;M
70231;238,1556,1651,1370,1200,1632;37;M
70247;799,605,724;70;F
70259;352,460,331,225,1663;31;F
70315;1355,476,277,1101,398,358,1632,460,1200,470,370,803,491,921,352;31;M
70392;943,1200,460,358,760,331,225,370,1108,395,476,491,238,921,352;11;F
70401;538,331,225,1200,370,605,933,1556,603,476,1101,491,805,1709,1089;29;F
70470;1556,359,225,331,358,1603,476,491,1709,1089,921;38;M
70503;1266,1370,225,1632,1603,491,476,803,370,331,1556,1101,238,1089,604;33;F
70613;1632,476,1603,370,352,1200,225,381,331,1266,1108,724,1556,1101,398;32;F
70633;1089,359,159,331,1101,538;30;F
70659;799,801,804,605,724,395,603,604;40;F
70712;803,1266;39;F
70717;803,933,1556,470,1200,1603,225,460,358,370,476,1101,491,921,352;32;F
70768;358,760,225,1200,817,1661,470,370,803,359,933,352,921,1101,1556;33;M
70807;470,921;48;F
70808;943,1200,1101,1709,1632,1606,381,1603,1370,1661,801,1266,1108,604,1724;42;M
70954;724,853,603,277,1101,491,921,352,1266,804,605,398,238,604,1724;40;F
71035;1266,1661,817,1370,460,358,225,470,370,359,724,933,491,476,921;50;F
71113;724;38;M
71200;1313,370,1108,921,352,1632,358,331,1603,1370,817,943,159,1651,1089;52;F
71201;1632,1556,476,491,1709,548,1089;63;F
71219;1089,603,933,803,1108,370,470,801,1661,159,817,1603,331,1606,1632;26;F
71264;724,921,1200,370,476,1355,358,470,1108,225,159,1101,491;36;M
71318;1200,225,1632,358,799,1663,1266,1108,933,476,398,1709,548,921,352;64;F
71406;1632,359,476,921;38;M
71436;1556;48;M
71525;395,603,805,460,381,225,470,803,1200,802,370,476,491,238,921;42;F
71529;760,1632,805,604,801,381,398,370,1266,605,1313,1108,1355,1101,538;30;M
71531;352,1200,1603,476;38;M
71686;331,470,1663,370,1266,804,1651,395,491,398,1724,604,548,238,1089;39;F
71804;806,1661,1266,804,605,724,398,805,604,538;42;F
71867;803,1663,370,359,1724,604,1709,853,1606,331,933,1556,603,548,921;25;F
71957;381,1556,1355,352,1632,1370,1661,1266,359,1101,491,238,921;29;F
71983;933,395,1603,225,358,1313,1370,943,1661,370,1651,803,476,1101,238;32;M
72005;801,817,943,1370,1603,460,1313,225,238,921,1606,1661,1651,395,476;27;F
72052;1632,331,1603,1651,603,805;37;F
72104;1370,225,358,460,1632,159,804,491,921,352;36;F
72153;1313,1355;52;F
72245;760,799,225,603,548,802,1266,398,724;40;F
72275;1632,331,817,1101,548,1089;35;F
72297;1089,603,395,1556,1266,802,1200,1603,1632,358,331,225,476,238;56;F
72336;1603,352,921,1101,853,1556,801,817,1370,225,460,238,476,603,724;18;M
72347;799,605,933,476,225,1200,470,803,724,1556,603,1101,921,352;26;F
72396;395,933,1603,331,1200,1651;73;F
72432;352,476,359,1200,225,1606;38;M
72452;460,331,1200,1556,476,1089,1108,1603,1632;44;M
72500;359,352,398,817,460,225,1200,801,470,370,933,1355,476,491,921;22;M
72585;358,331,225,1603,1200,470,370,359,933,1556,476,491,1089,921,352;31;F
72595;331,1200,370,803,359,933,1556,603,277,1101,491,805,548,1089,538;38;F
72598;801,398,548,802,395,799,238,381,804,803,1556,805,806,724,538;43;M
72635;358,817,802,804,803,603,1603,806,1200,1661,1266,933,1556,476,491;35;M
72660;460,225,1603,1200,370,470,491;77;M
72706;331,817,943,159,801,1651,724,805,238;46;F
72872;225,1200,470,1266;44;M
73138;470,1313,460,225,1200,1370,802,1266,1651,803,933,1556,238,1724,921;29;M
73260;538,921,1313,803,1556,476,1101,352;33;M
73267;1661,470,370,359,476,1101,491,1089,1724,538,921,1663,603,1709,352;29;M
73326;460,358,225,470,370,359,724,933,476,491,921;44;M
73385;381,799,806,724,1556,801,802,804,803,395,398,805,548,238,538;12;F
73440;476,1370,1200,1661,921;34;F
73469;352,921,806,331,1632,460,225,1603,1200,470,370,803,933,1355,476;43;M
73520;1313,1108,1355,1101,538;49;M
73567;1603,1632,358,225,331,1200,470,370,1556,1355,476,491,1089,604,921;22;F
73643;1108,724,1632,1709;30;M
73656;358,225,1603,1200,470,370,359,933,1556,1355,476,1101,491,921,352;26;F
73805;460,358,225,470,370,359,724,933,476,491,921;38;M
73829;943,1266,803,933,1556,491,358,1606,359,921,352,225,1200,470,476;37;F
73841;1632,358,799,801,802,1651,359,724,603,398,538,238,1089,604;27;F
73883;1370,943,1651,395,238;49;F
73900;491,921,352;29;F
73903;803,359,724,476,491,1709,1724;25;F
73929;225,159,1266,933,1556,476,491,398,238,1089,1313,1108,1355,1101,538;63;M
73937;1370,943,1651,395,238;69;M
73993;1632,381,799,806,801,802,804,803,395,398,805,548,238,604,352;64;M
74005;1101,395,359,1370,1200,806,460,331,470,370,803,724,1603,933,491;46;M
74021;1632,358,760,352,238,491,1108,1266,1661,817,1370,460,398,381,370;40;M
74036;460,358,225,470,370,359,724,933,476,491,921;;M
74057;1266,1370,1200,1556;56;M
74078;802,1661;21;F
74111;225,933,921,1370,476,470,1661;40;F
74117;1651,476,491,1632,358,331,225,799,1603,1370,603,853,398,381,370;35;F
74118;470,933,1556,1355,805,1089,352,331,801,804,359,476,491,238,921;28;F
74167;470,1200,1603,331,460,1632,225,803,1355,476,491,1709,1089,921,352;24;M
74169;1108,1556,476,1101,921,817,491,1632,1313,460,331,225,1603,1200,470;45;F
74185;538,352,359,1200,331,358,1089,603,1556,803,159,225,370,921,1101;31;F
74210;159,1101,1089;25;F
74304;1632,352,277,603,724,359,804,1266,1661,159,1370,331,1663,1709;30;F
74344;331,1101,1200,1603,225,1632;24;M
74380;1200,470,1266,359,724,277,921,460,760,225,491,352,358,331,159;48;M
74439;1709,1651,1663,943,1370,1313,358,359,933,395,921,352,1101,476,806;27;M
74443;331,460,225,1603,1200,817,802,470,370,1266,803,1556,476,491,398;33;M
74491;803,724,603,853,277,805,548,538;54;F
74508;491;27;M
74532;1651,1709,1370;63;F
74539;1370,943,1651,395,238;74;F
74567;1632,358;45;F
74589;1313,1108,1355,538;70;M
74650;1370,943,1651,395,238;71;F
74684;803,1632,1313,460,370,225,1603,1200,470,1108,1556,476,1101,491,921;73;M
74730;921,1089,352,460,1632,1606,225,1603,1200,1661,801,470,370,1101,1709;25;M
74784;803,470,817,1200,225,460,159,1632,1606,331,1603,921,1089,476,1101;30;F
74825;921,491,1101,476,1556,1200,1603,225,370,460,1313,1632,803;42;M
74859;358,1606,331,225,1603,1200,1663,803,724,933,1556,395,1355,476,491;33;F
74861;225,1603,1108,352,538;22;M
74948;921,491,476,724,933,370,470,225,358,460,1370,1266,603,395,238;41;F
74994;1632,1200,1651,460,358,225,470,370,359,724,933,476,921;33;M
75084;1632,1313,381,1370,802,1266,1108,803,1556,1355,476,1101,538;70;F
75102;1632,760,331,802,359,853,398,1089,352;50;F
75116;1661,470,933,1556,352,1632,760,331,225,370,1266,476,491,398,1089;60;M
75140;225,370,1651,1200,470,933,1556,395,1355,1101,1709,238,921,476,1089;45;F
75259;358,1200,1370,1661,802,1663,1266,804,1651,359,724,398,238;35;F
75264;470,801,1661,817,1370,1606,238,1089,1632,359,603,853,476,491,548;30;F
75322;1313,225,1603,1200,1370,470,370,803,1651,1108,933,1556,1355,476,491;40;M
75326;1663,1313;38;M
75369;1632,460,1606,331,225,1200,1266,804,359,933,1556,476,1724,921,352;46;F
75425;724,476,1709,238,352,381,799,1200,803,1556,1355,1101,398,1089,604;30;F
75438;1724,921,1266,1661,225,1632;22;M
75477;1089,1724,460,760,331,470,1651,359,933,1355,476,491,238,1370,1266;42;F
75486;470,805,1089,1724,853,370,1200,1603,238,352,225,460,817,476,491;29;M
75500;1603,1556,1632,358,225,1200,1370,943,470,370,1651,603,476,1101,238;39;F
75549;605,724,603,604;49;F
75619;359,933,352,1603,1200,803,395,1101,921,460,225,1556,476,491,238;41;M
75620;1556,491,1632,460,331,1370,370,603,1709,548,1089,1606,1661,476,921;27;F
75646;331,225,1370,1661,724,933,395,476,1101,1089,1632,159,238;50;M
75723;359,1200,358,460,1632,225,1603,159,470,803,933,476,1101,491,1089;13;M
75783;331,801,802,476,1556,1101,491,398,238;35;F
75795;799,1606,760,801,804,1108,603,1355,1101,805,1709,1089,604,1724,538;47;F
75806;1556,277,605,803,1101,476,921,352,225,370,470,802,1603,1200,538;67;F
75828;225,1603,1200,370,803,359,933,1556,476,548,921,491;75;F
76067;921,603,359,1632,1603,1200,817,1370,1661,1651,238,1089;32;F
76152;460,358,225,470,370,359,724,933,476,491,921;37;F
76272;1089,548,1709,491,1101,476,1556,933,470,460,1200,1603,225;38;F
76283;803,603,921,225,1313,1632,460,358,1603,1200,933,1556,476,1101,491;36;M
76541;933,395,1355,921,1556,370,1200,225,460,159,470,359,476,491,352;47;F
76556;159,470,1663,491,352,460,358,225,1200,370,933,1556,476,1709,921;27;F
76557;1101,476,1556,760,803,1089,1266,724,1632,331,1603,1108,921,1313,817;18;M
76575;603,1089,1101,476,1556,1651,470,802,817,225,1370,1661,491,548,238;50;F
76576;460,1200,1370,476;46;F
76605;1313,460,225,806,1651,1108,605,803,724,1355,476,277,1101,398,538;38;F
76613;1632,460,331,1603,1266,1108,724,398;42;F
76659;724,605,470,1313,1632,460,225,799,1603,1661,804,1266,1108,603,476;48;M
76721;352,1101,470,1200,225,460;35;F
76837;359,604,921,352,1313,460,225,1200,470,370,933,1556,1355,476,491;37;F
76870;605,603,604;54;F
76898;358,1313,460,1606,331,1603,1200,801,470,370,1556,491,1709,238,1724;58;F
76912;1355,1724,352,460,225,1200,470,370,359,933,476,491,921,1709;50;M
76967;1724,238,460,358,225,470,370,359,724,933,476,491,921;50;M
76973;1313,460,225,1200,1108,933,603,853,476,1101,921;46;F
76974;460,358,225,470,370,359,724,933,476,491,921;21;M
76981;933,803,605,1266,801,817,1370,1200,799,1313,1632,1556,1651,1661,1603;29;F
77189;370,460,1632,1200,1313,225,943,470,1266,933,476,1709,1089,921,352;32;M
77204;548,921,352,225,1200,817,1108;44;M
77317;933,395,1355,398,604,921,352,806,802,1266,1651,1556,853,1101,548;30;M
77365;1370,460,370,921,1606,358,331,225,1603,476,238,352,1200,470,1556;44;F
77472;352,358,1606,331,225,1603,1200,1370,470,370,933,1556,476,491,238;14;F
77482;1370,359,1556,803,1603,358,460,225,1200,470,370,933,476,921,491;49;F
77485;1603,1663,853,1089,1632,760,806,1370,801,1266,359,395,476,238,538;74;F
77582;724;44;F
77595;159,225,1370,1108,359,476;33;M
77755;1632,331,470,1200,1606,225,1603,803,359,933,1556,476,491,921,352;33;F
77781;358,538,803,921,1101,225,1200,470,724,1556,476,491,1089;46;F
77788;803,1355,491,460,331,225,1603,1200,370,933,1556,476,1101,1089,921;42;M
77828;724,921,460,358,225,370,359,933,491,476,470;36;F
77843;1266,1355,476,238,1089,352;39;F
77859;1089,1101,603,460,1663,352;32;F
77867;921,1313,460,1370,370,603,225,470,476,1632,1200,817,1101,352;42;M
77875;358,538,1355,724;32;F
77912;1313,933,1556,491,352,1632,460,331,1603,476,277,1101,238,1089,921;70;F
78085;802,801,817,1370,1200,806,1603,225,331,460,491,548,238,604,352;32;M
78127;370,803,724,604,921,853,603,1108,1266,470,1632,476,1101,491,548;42;M
78147;1632,460,331,1603,933,1556,1355,476,277,1101,491,238,1089,921,352;70;M
78151;1370,1632,381,1663,1108,724,238,604,538,805,398,804,1661,802,1266;42;F
78190;1089,933,1200,460,1313,1632,1606,331,225,470,370,359,476,1101,491;37;F
78222;358,460,1313,1632,801,470,1266,804,605,1101,604,370,476,491,352;38;M
78289;1370,1313,352,921,359,1200,225,460,358,1632,1603,1651,1556,491,238;60;F
78338;1556,476,803,359,724,1089,1661,1200,331,1632,1313,760,1101,921,352;52;F
78393;470,370,605,359,933,491,921,331,803,1556,603,476,805,1089,352;60;F
78398;1632,799,1200,1370,331,1603,817,370,548,491,352;47;F
78458;1313,1108,1355,1101,538;4;M
78498;460,470,370,1651,605,724,277,1266,1108,803,1355,476,1101,398,538;41;M
78512;1603,1556,470,460,358,225,370,803,359,933,603,476,491,1709,921;36;F
78571;359,1556,238,805,476,1724,358,1108,1101,1651,538,460,603,1355,1709;53;F
78591;803,370,470,799,460,331,225,1200,817,1661,1266,476,491,1089,921;32;F
78603;538;52;F
78650;1101,921;38;M
78732;470,225,805,538,921,1101,724,605,802,801,159,331,1606,358,460;29;M
78753;225,460,476,1108,1266,370,470,943,1200,1101,331,358,760,1556,238;37;M
78805;1651,943,806,799,331,476,491,548,1089,921,1661,370,1355,398,538;36;F
78806;1556,1632,225,1200,803,359,933,395,476,1089,352,1370,159,238,921;64;F
78848;799,801,1661,724,381,806,802,804,803,395,398,805,548,238,538;8;M
79005;1370,1661,470,476,933,225,921;50;M
79042;724,381,799,806,801,802,804,803,1556,395,398,805,548,238,538;10;F
79043;460,1606,331,225,1603,806,1200,802,470,370,359,476,491,1724,352;48;F
79056;1661,476,1101,1089,1724,358,1200,801;19;M
79092;801,802,470,803,359,724,933,603,1556,476,604,921,1632,1313,225;37;F
79181;358,1370,801,470,370,1108,804,359,724,933,476,491,1724,921,352;46;M
79213;933,1556,476,1709,1724,460,359,1101,921,352,1200,1603,225,331,1632;30;M
79236;1663,359,1556,853,476,548,799,1603,801,1651,395,352;34;M
79239;460,225,1200,817,470,370,933,603,476,1101,491,805,1089,921,538;22;F
79302;933,359,803,470,1200,331,1606,460,358,225,159,370,605,476,491;2;F
79356;460,1603,1200,1370,933,1556,476,238;46;M
79409;933,359,803,1200,806,1632,460,331,225,1603,470,370,476,491,921;33;M
79507;803,1724,381,1606,460,358,225,470,370,359,933,476,491,921;56;M
79558;460,358,225,470,370,359,724,933,476,491;30;M
79564;460,225,1200,370,724,933,476,491,921,817,358,1661,359,1709,1089;30;F
79607;225,359,476,352,1603,1200,1370,1663,1266,1651,933,1556,395,491,238;36;F
79620;1313,1101,1355,1108,538;23;M
79661;460;27;M
79687;331,381,799,1603,1370,817,943,802,470,804,1651,476,398,1632,238;32;F
79911;799,398,548,1266,352,1663;30;M
79960;460,358,225,1200,1370,943,1266,933,1556,395,1355,476,1101,238,921;31;F
80034;1266,804,605,1101,398,1724,352,1089;50;M
80084;1313,460,1603,1200,159,470,370,359,933,476,1101,491,238,1089,352;30;F
80090;331,804,538,1108,803,603,476,491,1089,1661,1603,225,760,1313,460;38;M
80118;358,491,548,1089;51;F
80153;395,1355,1101,604,352,225,460,358,799,817,803,853,491,548,538;39;F
80199;933,1355,1089,1724,1632,1606,1603,1370,1663,1651,1556,395,1101,805,1709;36;F
80232;1200,933,1556,603,476,805,1089,921,352,225,799,1603,370,359,1724;53;F
80306;1632,803;70;F
80353;491,460,359;44;F
80368;803,358,470,359,724,1632,1709,1724,460,225,370,933,476,491,921;48;M
80390;943,470,804,460,1313,1632,381,225,1266,605,359,933,1355,476,398;64;F
80414;817,943,1661,801,802,1651,1355,548,1089,1724,359,1632,1603,1709,238;28;F
80432;1313,1108,1355,1101,538;41;F
80456;1313,1108,1355,1101,538;44;M
80606;1313,1200,225,803,359,933,476,491,921,352;42;M
80648;460,352,538,1724,1089,238,1101,476,1355,359,803,1266,470,1200,225;52;M
80652;1632,460,358,225,1200,943,801,470,370,359,1556,476,1101,491,921;24;M
80661;359,603,491,921,352,1632,460,331,225,1200,933,1556,476,1101,548;27;M
80704;1313,1108,1355,1101,538;11;F
80713;460,1200,933,1556,921,358,370,724,491,476,470,225,331,1108,1101;28;M
80716;225,331,460,1632,548,538;47;M
80777;1632,460,225,1200,1370,159,1556,1355,476,491,801,470,370;60;F
80797;159,1661,1651,1108,933,1556,491,1632,358,331,1603,802,370,476,238;31;M
80935;460,1663,476,1632,1661,1266,804,1556,1355,1370,370,491,1709,238,1089;40;F
80982;933,724,605,817,460,470,803,359,603,1355,476,491,805,921,352;51;F
81001;331,358,1200,1661,370,1266,803,359,933,603,805,460,1556,491,921;31;F
81066;1089,921,460,331,225,1603,1200,159,470,1663,370,1556,476,491,1709;24;F
81068;358,225,359,933,1556,476,1101;28;M
81106;548;33;F
81286;1200,538,1709,491,853,1556,801,817,225,331,1101,803,476,548,921;26;M
81334;331,1313,1632,358,225,1603,1200,159,470,370,803,1556,491,921,238;34;M
81401;460,225,470,370,359,724,933,476,491,921;47;F
81409;460,331,225,1603,1200,1556,1266,933,476,491,1089,921;42;F
81417;331,1603,1200,470,359,395;29;F
81420;1632,921,1101,476,1200,225;33;M
81497;358,1606,331,225,1603,1200,370,803,933,1556,476,491,238,1089,921;25;F
81532;470,933,476,921,1200,1603,331,395,603,1709,943,1370,1651,238,1089;52;F
81723;398,804,760,358,1606,1603,1661,1266,1108,603;43;F
81802;395,277,398,548,1370,802,1663,853,1355,1089,1724,604,538,352;34;M
81888;476,491,238,921,352;85;M
81935;1266,799,806,1370,943,802;46;F
81970;1632,381,1603,802,1663,1651,1556,603,476,398,805,238,921;40;M
81979;491;74;M
81997;476,225,1603,803,359,352,799,1606,1632,159,605,1101,548,805,1089;59;F
82003;491;82;F
82070;801,802,238,352,358,1632,159,470,370,803,359,933,1556,476,491;45;F
82084;1556,921,370,470,225,460,1200,933,1355,398;36;M
82170;760,1603,1200,1661,470,370,1651,803,933,1556,476,1101,491,921,352;30;M
82177;1663,1709,760,1606,1200,1556,1355,1089,352,1632,1603,1661,1266,1108,398;41;F
82242;1266,1661,1313,1632,358,331,1606,1603,1200,1370,159,933,1556,476,352;38;F
82307;1651,605,1200,1603,225,460,1632,1370,359,603,476,1709,238,1724,352;51;F
82347;1556,933,1266,470,1200,1603,225,331,358,460,1108,803,1101,491,538;39;F
82378;225,1200,470,359,803,933,476,921,460,1606,331,1603,491,1089;50;M
82429;1556,476,1101,491,1089;31;M
82433;370,1266,804,605,724,805,238,538;38;F
82480;358,1200,817,1661,802,933,476,491,1724,1370,359,331,470,370,921;43;M
82567;1101,1089,1632,358,1603,806,1370,1661,1266,804,1651,803,359,548,238;50;F
82574;802,370,1266,804,803,933,1556,1355,476,277,1101,398,805,921,352;35;M
82618;460,1632,1313,331,1200,1370,370,1651,803,359,1556,1101,1709,238,1724;25;F
82630;806,460,1632,1370,1603,1200,476,943,1651,1556,238;53;F
82712;806,1370,470,370,1651,933,238,491,921,460,358,225,1200,1663,476;37;M
82732;1370,943,1651,395,238;74;F
82745;1632,331,1200,1108,803,724,1556,603,1355,476,1101,398,238,1089,921;33;F
82794;1370,943,1651,395,238;82;M
82863;1632,1313,358,1603,1200,943,470,370,1651,1108,1556,476,491,238,352;38;F
82869;801,1108,359,1556,491,921,1200,358,460,1313,1355,476,548,352,398;42;M
82881;1370,943,1651,395,238;86;F
82921;381,159,1661,802,1108,1355,805,799,1266,605,724,277,398,604,538;53;M
82952;1632,1313,331,1266,1108,1355,1101,538;72;M
82993;724,933,1556,395,603,853,1355,476,491,398,805,548,238,921,538;52;F
82998;1603,1370,817,470,370,476,491,398,805,921;67;F
83045;1313,1632,331,470,370,803,476,1101,491,805,548,238,921;31;M
83058;1603,491,1661,1632,225,331,803,933,476,1101,805,238;32;M
83148;933,238,538,370,476,470,1200,803,805,1370,1556,1603,548,1632,225;40;F
83181;724;59;M
83215;724;59;F
83266;1266,804,933,359,1089,1632,1603,159,1661,1663,1556,476,491,548,921;24;F
83269;476,277;33;M
83364;1603,1370,395,476,1101,238,921,352,381,799,1200,802,470,804,398;32;F
83394;358,331,470,933,1556,603,921,352,460,1603,1370;32;F
83426;395,370,491,933,359,548,476,806,225,470,1556,460,358,331,803;23;M
83448;225,470,1355,1606,1632,1313,331,1603,1200,1556,603,476,1101,1089,921;49;F
83586;331,817,933,1101,491,1709,921;31;M
83683;460,358,225,1603,1200,1108,803,1556,476,491,921;16;F
83732;1370,1313,803,359,933,476,238,1661,943,1603,225,460,491,1089,352;18;M
83770;1370,331,724,460,358,225,159,470,370,359,933,476,491,1089,921;36;F
83801;331,1603,1370,1663,1651,359,1556,1101,238,352;44;F
83858;1556,1355,398,805,352,1200,1603,225,381,331,460,476,491,604,921;47;M
83865;1370,817,801,470,370,605,1101,805,548,238;21;F
83904;460;30;M
83940;460;29;F
83984;1632,1313,225,803,359,933,1101,352,1663;43;M
83995;358,1606,331,225,1603,1200,933,603,491,805,476;36;M
84034;1663,1266,398,1089,804,724,548;39;F
84066;225,1603,1200,1370,470,370,803,933,1556,395,1355,476,1101,491,921;39;F
84187;1108,1313,1101,538;35;M
84264;802,1370,1200,1603,225,933,1556,476,801,1266,331,358,460,1632,1101;46;F
84339;358,460,225,470,359,724,933,476,491,921;35;M
84398;331,1603,1370,803,1101,1089;51;F
84425;331,370,1200,933,352,470,1651,359,1266,395,603,476,491,805,398;31;F
84434;548,1089,491,1556,470,1632,370,476;62;F
84447;381,801,802,605,799,1661,1266,804,398,604;41;F
84462;1370,943,1651,238;53;F
84489;476,1089,724,803,1266,1603,331,1606,1313,225,1200,1661,470,1556,491;52;M
84509;491,238,1632,1313,460,225,1603,1200,1370,1651,933,1556,395,476,921;32;M
84536;381,1313,460,806,1200,470,803,724,933,1556,805,491,1355,476,277;64;F
84680;1370,1661,1266,1651,460,760,470,159,370,933,1556,491,1101,1709,1089;25;F
84763;933,470,159,1200,225,460,801,803,359,603,476,1101,491,548,352;46;F
84815;470,359,476,921,1200,225,1313,491,352;48;M
84910;1632,1313,358,359,724,1101,398,1709,538,352;39;F
84969;1313,460,358,1606,225,1603,1200,370,603,1355,476,398,1089,1724,921;61;F
84970;225,1370,1661,802,1663,1266,724,238,538;43;F
85031;225,358,460,1632,1313,331,1603,370,1108,476,538,548,491;36;F
85100;1108,538,159,358,933,476,491,1200,359,803,724,1556,1101,1089,921;15;M
85117;1632,331,460,225,470,933,1556,476,491,921,238,1089;28;M
85127;238,1101,1632,1603,331,225,1200,470,1108,359,933,1556,476,921,352;66;F
85148;1632,460,225,359,476,352;34;M
85151;358,370,359,921,476,460;39;F
85171;331,460,225,1200,802,470,370,803,1355,933,1556,476,491,1709,921;33;F
85400;803,1663,801,1661,1603,1632,331,1200,1370,159,359,1101,1089,538,352;46;F
85402;538;44;F
85541;802,724,603,277,1101,805,1089,604,538;25;F
85557;1108,1200,225,921,1101,476,1556,370,806,1603,331,358,1313,1632,352;50;F
85577;1313,381,806,802,1663,804,1108,605,1355,277,398,805,1709,538,352;45;F
85616;548,1089,1632,358,331,1370,817,1661,801,1266,1651,359,933,1556,603;31;F
85640;238,604,1606,331,1603,1200,1661,803,1556;33;M
85642;370,933,1556,476,238,460,358,1200,1370,159,803,603,1101,491,352;31;F
85657;470,1632,225,799,159,804,605,803,603,476,491,398,805,1089,538;21;M
85659;331,225,470,370,1108,803,1556,1355,491,538;50;F
85677;943,395,491,1724,1632,1370,1651,476,238;63;F
85863;1632,1313,460,225,1200,1266,359,933,1355,476,491,352;43;M
85887;1266,801,1632,460,358,225,1200,1108,359,476,1101,398,805,548,352;64;M
85990;1632,460,331,1603,1200,1370,1651,1556,1355,476,277,238;55;M
86041;359,803,804,943,802,1370,799,398,1266,1661,1313,1632,1603,1200,1108;37;F
86124;724,802,470,370,603,491,921,358,331,1603,1200,1108,803,359,1556;46;F
86132;1355,548,1724,921,358,1200,803,359,724,1556,476,805,238,277,352;16;F
86235;359,1556,352,921,1313,460,331,470,933,1089,1632,817,370,476,491;36;F
86242;933,277,238,359,1266,398,1709,1724,491,470,225,724,476,1101,352;42;F
86353;817,381,604,548;57;F
86409;921,1089,1632,1603,1200,1370,817,370,1266,933,1556,603,476,1101,491;54;F
86451;1663;45;F
86470;460,225,470,370,803,359,933,1556,853,1355,476,1101,491,548,921;34;F
86497;1108;70;F
86585;943,358,460,1632,1313,331,225,1266,1651,603,853,476,491,548,238;33;M
86623;1200,225,1632,460,799,1603,817,1661,801,853,476,1101,491,805,548;50;F
86635;1313,381,806,802,1663,804,1108,605,1355,277,398,805,1709,538,352;46;M
86658;1313,1632,358,476,491,238;20;M
86692;331,358,1370,370,1108,803,724,933,1556,476,491,238,1089,921,538;43;F
86719;358,331,470,370,476,491,1089,921,460;29;M
86728;1266,1370,1603,1661,370,933,1101,1089,352,1632,760,1200,1556,476,921;41;F
86734;1661,1266,491,1632,1603,1370,159,1651,803,395,1355,604,398,805,238;41;F
86781;225,921,352,1603,1200,1370,476,1632,331,1556,1089;45;F
86799;605,470,817,1200,225,331,358,1632,370,1108,724,1355,476,1101,491;34;F
86811;1313,1603,1200,358,460,331,225,370,470,359,933,1556,476,491,921;33;F
86847;1603,225,470,1663,1108,1556,548,1089,1632,331,1200,724,603,1355,1101;29;F
86883;1603,1355,476,1632,460,1313,331,225,1200,470,370,1556,491,921,538;31;M
86914;801,1108,803,1556,603,1355,277,238,921,538,476,933,724,331,805;42;F
86944;1313,381,806,802,1663,804,1108,605,1355,277,398,805,1709,538,352;11;F
87006;1200,799,802,605,548,1603,1556,603,1089,331,803,805;44;M
87027;1632,1603,1663;65;M
87030;1661,1651,1556,1632,1313,460,225,1603,1200,470,603,476,1101,491,921;32;F
87033;1632,1603,1661,1101,352;42;M
87091;470,370,1266,1108,933,1556,1355,476,491,398,548,238,1089,604,921;44;F
87122;538;41;M
87147;1313,381,806,802,1663,804,1108,605,1355,277,398,805,1709,538,352;7;M
87163;1632,1603,1663;63;F
87164;803,359,370,1632,460,358,1606,331,1603,806,817,159,1556,805,921;44;F
87202;921,352,1089,1606,331,460,1632,225,1661,802,470,1108,1101,491,1651;29;F
87212;1632,1370,476,1101,548,238,921;34;F
87215;1266,1101,1089,1108;42;M
87259;1089,1709,277,724,605,760,1632,331,1603,1200,804,933,1556,476,1101;47;M
87290;1663;60;F
87324;1632,460,358,1606,331,225,1603,1200,470,359,933,921,476,491;53;F
87401;395,225,476,491;47;M
87402;460,1603,470,370,476,1089,921;45;F
87408;1200,801,933,803,1355,1709,225,476,921,548,1724,1089,460,1606,331;30;F
87418;853,548,799,817,1661,933,1101,476,921,1355,1200,225,1370,1651,1632;36;F
87462;1632,331,370,724,1101;47;M
87496;538;39;F
87532;1632,1370,1661,1266,1108,359,1355,548,238,1724,538,352;74;F
87547;1603,1661,803,933,476,921,1632,225,159,470,370,1556,1101,491,1089;20;F
87568;1313,358,1370,1108,1355,1101,538;28;F
87612;1370,1663;90;F
87731;1632,1313,1200,238,352;36;M
87753;548,1370,1266,1651,395,398,352;32;M
87765;225,801,470,476,1556,933,1370,1200,1603,460,238,921;82;F
87767;358,1603,1370,801,370,605,803,933,1556,603,1355,476,491,805,1089;34;F
87793;358,1355,460,1313,470,1556,352,1724,238,548,491,370,359,476,1632;39;M
87816;1663;61;M
87823;1108,804,370,470,1661,1632,1313,1200,1266,803,933,1556,1355,1101,491;31;F
87831;817,799,1632,1370,1266,1556;57;F
87834;1603,331,943,470,358,1606,225,370,803,359,933,1556,476,1089,352;35;M
87842;803,359,476,491,1089,352,277,548;67;M
87847;604,1632,802,1661;46;F
87850;238,491,476,395,1556,1108,1651,470,943,1370,1200,225,331,460,1313;70;F
87931;1266,804,724,491,398,238,538;33;F
87933;238,548,476,395,1606,225,799,1200,817,802,803;30;F
87935;159,1370,1200,1603,331,1606,1089,358,1661,801,395,476,805,238,538;10;F
87987;1200,159,359,1556,603,476,491,1709,921,352,460,1606,1603,331;30;F
87994;1089,470,331,1632,460,225,1603,1370,370,803,1556,603,1355,805,238;69;F
87998;331,799,803,359,853,476,491,548,1089,352,277;66;F
88004;1108,352,802,1661;45;M
88028;1313,358,921,370,470,1200,331,460,1632,225,1603,933,476,491,1089;41;M
88111;933,1556,805,352,460,1200,238,538,1101,225,159,1661,395,491,921;49;F
88112;1266,352,1313,460,225,470,370,921,331,1603,1200,802,933,1556,476;51;F
88125;238,476,395,1556,1108,1651,370,470,943,1370,1200,1603,225,331,460;73;M
88154;548,491,603,470,817,1370,460,370,1266,1108,933,1355,1101,538,1632;50;F
88195;460,225,1266,803,933,476,491,805,548,1089,604,538;51;M
88231;359,603,1101;56;M
88240;817,799,225,1632,1370,1661,603,853,476,1089,921,352;63;F
88276;1606,1370,943,1651,1556,603,1632,331,1603,1661,470,802,491,238,1089;24;F
88367;460,225,1661,470,370,933,476,491,238,921,1266;47;M
88427;460,760,225,1200,1661,1266,804,1355,398,352;38;F
88458;1200,1370,1266,1556,352;46;F
88487;1370,1200,1266,1556;55;F
88564;760,801,1663,1266,605,724,395,1355,476,1101,398,805,1709,238,604;33;F
88586;1313,802,1556,460,331,225,1603,1200,1370,1651,476,1101,491,1709,1089;37;M
88708;395,1089,943,470,1266,476,491,238,225,352,1724,460,1632,370,1355;36;M
88731;1313,225,1603,1200,1108,933,1556,476;33;M
88753;803,470,225,1606,460,331,1603,1200,359,1556,933,476,491,921,352;32;M
88756;225,1603,1200,470,370,1266,804,1651,359,933,476,491,1709,1724,352;41;F
88783;470,370,1108,803,724,933,1556,476,381,1355,1101,491,805,604,538;46;F
88828;1313,760,1606,331,817,1661,802,603,1355,1101,548,238,1089;23;F
88875;1632,358,331,225,806,1200,1661,802,1108,724,277,398,238,1089,538;49;M
88886;1370,1200,1603,225,460,1632,370,1651,933,1556,395,476,491,238,921;37;F
88890;548,538;25;F
88899;943,817,799,1313,331,159,1661,804,238,805,1355,853;43;F
88920;1266,538;39;F
88943;1266,1101,470,159,1556,921,1200,804,760,548,476,1603,1632,331,1089;43;F
88971;1606,538,352,395,491,1089;21;F
89101;1632,1606,460,331,1603,1200,1370,1266,1556,476,238;81;M
89140;470,358,1603,1200,370,1266,803,238,352,1632,1313,359,1556,476,491;34;M
89175;803,470,1603,331,1606,760,460,1370,1266,724;41;F
89222;352,395,803,1651,370,470,1370,225,760,1313,1632,1108,1355,1101,538;58;M
89255;460,1200,370,359,1556,476,1101,491;33;M
89319;359,1370,1200,225,1556,476,1724,1709,1632,460,1606,331,1603,803,1089;41;F
89388;1661,604,804,802,398,370,359,277,1108,1101,1266,1632,805,801,605;41;M
89431;358,760,943,159,1108,277,538,352,381,1370,1651,724,359,1355,238;3;M
89485;460,1603,1200,470,370,538,921,803,933,1556,395,1355,476,491,1089;64;F
89505;398,538,806,1266;49;M
89523;548,470,370,801,921,1370,1661,1632,817,476,460,331,238,225,159;25;F
89582;370,1556,476,491,538,460,225,1200,470;38;F
89633;1632,1606,331,1603,1370,943,1661,802,470,1651,1556,603,491,238,1089;64;F
89634;1313,801,470,603,1355;25;F
89689;799,1632,853;70;F
89691;1108,724,395,277,538,1101,799,1370,605,603,853,398,805,548,238;59;F
89727;921,548,476,359,1313,358,225,1603,1200,470,491;37;F
89793;1313,1108,1355,1101,538;57;M
89844;460,331,225,1200,359,933,603,476,238,921,943,470,370,803,1556;42;F
89872;538;19;F
89944;1266,605,724,398,1709,548,1724,1661,1200,760,1313,1108,1101,538;10;F
90024;460,225,470,370,803,933,1556,1200,331,1603,476,491,1089,1724,921;55;F
90052;604,1556,359,1200,358,460,331,225,1603,470,370,933,476,491,548;38;M
90055;802,943,1661,1663,804,724,853,398,805,548,604,238,1709,1603,1632;55;F
90193;1632,799,1200,1370,853,277,805,548;63;F
90235;1632,1603,817,1661,802,370,1266,724,1556,853,1355,491,548,238,1089;38;F
90287;538;24;F
90292;476,605,1651,801,1603,460,1632,331,1370,802,1556,853,1355,805,548;49;F
90298;1556,603,853,398,805,1709,238,538,352,331,1661,1266,1355,491,604;32;F
90395;799,1632,460,358,1200,470,1266,1108,1355,476,1101,548,921,225,381;38;M
90415;460,331,1603,1200,159,933,1556,476,491,352,921,1101,803,806,225;32;M
90439;604,1556,359,1200,460,358,331,225,1603,470,370,933,476,491,548;40;F
90461;803,1200,1089,1603,1632,921,491,476,933,359,370,470,225,358,460;50;F
90462;358,331,470,1108,1101,1089,538;43;F
90469;358,760,1603,1370,802,1663,803,1709;38;M
90488;225;26;F
90499;921,1632,1606,331,1603,1370,1200,1661,470,1651,1556,476,491,238,1089;90;F
90504;225,1603,1663,1724,352,1709,1632,460,476;29;F
90603;1632,1603,1355,491,238,921,1370,943,1651;33;F
90607;238,1556,460,331,225,1603,470,803,933,476,491,1089,921,370,359;35;M
90628;1313,358,225,370,803,359,933,1556,1355,476,491,805,1709,1089,921;14;F
90629;370,817,1370,331,460,1632,1661,491,1089,1108,1101,476;26;F
90663;538;31;F
90665;538;33;M
90685;1556,548,921,352,1632,460,331,225,1603,1200,803,359,933,476,1089;30;F
90702;933,359,1603,358,806,1200,1108,476,921,331,159,277,1709,238,538;25;M
90715;603,398,604,352,460,1200,159,1266,803,724,1556,476,805,238,538;42;F
90718;803,395,491,225,331,1606,1632,460,1200,806,1370,817,476,238,1089;42;F
90758;460,358,225,470,370,359,724,476,933,491,921;35;M
90856;724,538;65;M
90868;1632,1313,460,358,331,225,799,1603,1200,1370,802,1556,476,921,352;37;F
90885;805,1709,538,352,358,225,801,1663,1266,605,724,933,1355,491,921;42;M
90924;1632,331,225,1603,1200,159,801,802,1663,804,359,603,476,398,1709;34;M
91027;460,1313,1606,331,225,1200,370,1108,724,933,1556,476,491,238,921;49;F
91051;1370,943,1651,395,238;40;F
91103;1266,605,1089,604,538,238,331,1370,1663,1651,359,1709,352,1632,1101;52;M
91122;460,358,225,470,370,359,724,933,476,491,921;38;F
91137;1370,943,1651,395,238;10;M
91172;1370,943,1651,395,238;8;M
91216;1266,804,933,1556,476,491,805,1709,548,1089,1724,352,460,331,381;32;F
91239;460,331,225,1200,817,159,470,803,359,1556,603,476,1101,1089,370;21;F
91276;801,804,803,603,476,238,799,1266,853,277,398,805,548,604,538;40;F
91288;1108,803,724;46;M
91312;1101,538;64;M
91406;359,1556,1355,476,491,921,470,1661,1200,225,370,1266,1101,238,352;34;M
91501;395,1370,943,1651,238;6;M
91619;1101,491,921,352,476,1556,933,359,470,1200,1603,225,331,358,1632;64;F
91680;1101,1266,370,802,1089,476,1556,933,1661,1370,225,331,1632,1603,803;60;M
91765;801,548,460,358,225,470,370,359,724,476,491,921;29;F
91889;1313,1108,1101,1355,538;49;M
91909;803,724,921,1313,358,331,225,1603,1200,470,359,933,1556,476,352;45;M
91917;331,548;50;M
91922;1313,460,358,225,470,370,359,724,933,476,491,921;54;M
91935;460,358,225,470,370,359,724,933,476,491,921;52;F
91957;603,476,1101,805,460,331,1370,1651,1355,491,1709,238,1089,1724,352;25;F
91966;460,1603,1370,943,1651,803,395,476,358,331,159,470,359,1556,1101;43;M
91978;470,358,1632,225,806,1200,1370,1661,1266,803,933,1556,1101,238,604;26;F
92015;1651,1266,804,470,802,1632,1313,760,1603,1200,1370,1661,1108,1101,1089;48;F
92045;1266,803,395,352,331,1603,1370,817,943,1661,1651,1108,238,1089,1632;43;F
92084;921,476;33;F
92131;603,1101,398,1089,352,358,331,1603,817,1661,470,370,933,491,921;40;F
92138;853,1355,476,548,238,921,470,1101,1089,352,1632,225,799,1200,817;52;F
92235;1313,1108,1355,1101,538;48;F
92266;225,460,799,817,1108,605,853,238,1661,603,548,370,476,491,921;54;F
92315;1313,1108,1355,1101,538;59;F
92383;1313,760,1108,1355,1101,538;10;M
92409;1632,331,933,476,491,1089,921,352,460,358,225,1603,1200,470,359;29;M
92459;159,491,921,352,476,1556,370,470,1603,331,460,1200,1089;21;F
92546;358,331,381,943,460,225,1370,470,370,491;44;M
92556;225,806,159,1089,604,921,1200,933,476,460;29;F
92635;801,804,605,724,933,603,853,1355,476,491,398,805,548,604,1724;35;F
92659;1200,225,331,760,460,1632,1556,933,476,1101,398,1709,805,352,921;49;M
92766;1556,277,921,538,352,1313,460,358,331,370,724,933,1101,491,1089;24;M
92823;1556,548,1089,538,1200,460,358,1606,331,817,159,1101,238,921,352;32;F
92840;358,331,225,1661,1108,359,491,548,238,921,352;22;M
92883;724,853,277,398,805,548,1089,538;68;M
92907;1603,159,370,933,1556,1355,476,491;28;F
92914;1632,1200,159,359,933,1556,1101,491;31;M
92921;225,1603,1200,159,370,933,1556,476,491,1709,359,548,238,1089,1724;30;F
92978;395,476,1101,491,1709,238,921,1651,1663,470,159,943,225,760,1370;24;F
92989;1632,225,1200,1101,921;32;M
92995;225,331,1313,460,1200,470,370,1108,803,359,933,1556,476,491,921;32;M
93000;460,476,1101,491,921,370,803;30;F
93019;799,225,760,331,460,801,802,921,603;26;F
93053;331,225,1200,470,1108,803,359,933,352,1101,1632,1603,1556,476;59;M
93077;460,331,225,802,238,1089,921,352,1603,1200,1370,476;46;F
93092;1200,159,470,370,1108,803,359,724,933,1556,1355,476,1101,491,921;40;M
93182;1313,799,1603,470,1266,803,359,603,476,1709,548,1089,921;20;F
93250;1101,1556,724,359,1266,802,159,1370,1200,1603,331,358,460,1313,1632;40;F
93299;1089;32;F
93336;1313,1661,802,1663,1266,1108,603,1355,1101,398,548,1724,1089,604,352;11;M
93349;1266,1603,460,1606,331,225,1200,1370,470,370,933,476,491,1089,921;57;F
93384;225,1603,1200,817,605,933,1556,603,853,476,1101,398,805,548,921;21;M
93428;1632,358,760,817,159,1651,603,1101,238,1089,604;30;M
93431;358,460,331,225,1603,1200,1370,470,359,933,1556,476,491,1089,921;39;F
93457;460,1632,470,803,359,806,476,491,1101;31;M
93466;921,460,225,724,359,370,1603;32;F
93529;491,921,460,358,225;39;M
93565;225,724,1200,1603,460,358,760,933,1556,921,1661,1632,1313,1108,1101;37;F
93629;603,476,491,238,1089,921,803,1266,370,802,1370,1603,1200,225,331;16;F
93793;1632,381,799,806,817,801,802,804,803,395,398,805,548,238,352;43;F
93794;1370,943,1651,395,238;70;F
93879;805,817,159,801,1355,491,1089,604,1370,603,238;22;F
93898;1632,1603,1200,1651,1355,1370;68;M
93899;370,1108,331,1200,159,470,803,1556,352,1089,359,933,1101,491,921;26;F
93938;460,331,225,1603,1200,470,370,804,1266,803,1556,1355,476,491,921;46;M
93949;1089,1101,277,603,359,470,225,1313,802,370,724,1355,491,805,238;35;M
93955;358,1370,943,1651,395,398,238;45;M
93956;803,1632,381,799,806,801,802,804,395,398,805,548,238,604,352;33;F
93958;381,1370,801,1661,802,1663,603,1355,1101,805,238,1089,538,1724,352;5;F
93965;1632;38;F
93970;225,1200,1370,359,1556,1355,1089,921,352,460,358,331,1603,933,476;49;F
94004;1200,817,1370,943,1651,238;44;F
94021;395,1313,225,1603,1200,159,470,370,724,933,1556,476,491,921,538;28;M
94026;806,1266;35;F
94084;1661,370,804,238,604,760;57;F
94130;1632,381,799,806,801,802,804,803,395,398,805,548,238,604,352;40;M
94149;921,352,476,1355,1632,1313,460,331,225,1200,159,359,933,1556,491;20;F
94168;395,1556,724,359,943,1370,1603,225,358,460,331,801,1266,803,491;20;F
94171;460,1313,331,1603,159,933,1355,476,1101,1089,921;52;M
94174;1313,358,159,1661,476,238,352;38;M
94183;943,760,1370,225,460,1313,1606,331,1603,933,1556,476,491,548,1089;33;F
94198;1632,1370,370,1556,476,491,548,921;19;M
94218;799,1661,802,1266,605,724,603,277,398,538;39;F
94262;1632,1603,1661,370,603,491,1089;44;F
94275;943,1724,921,352,1556,933,225,470,491,460,331,1200,1603,370,476;26;M
94398;724,603,805,476,238,921,1089,1661,1603,225,460,817,802,470,1663;21;M
94446;225,1200,470,370,803,359,933,1556,395,1355,476,491,1089,352,921;35;M
94486;1370,1663;82;F
94566;1632,801,1266,804,1651,359,1556,398,604,921,352;36;M
94605;358,331,225,1603,1200,1370,470,1663,359,933,1556,476,491,1089,921;5;M
94671;1709,1089,1724,1632,460,358,225,470,370,359,724,933,476,491,921;53;F
94673;853,395,724,359,1370,1200,225,358,460,799,817,802,370,933,603;32;F
94684;358,1606,1370,802,476,359,352,921,1101,1200,1603,331,1632,1313,1556;54;M
94864;370,470,943,817,331,1313,603,853,476,1101,491,548,604,921,538;25;M
94890;1632,460,331,225,1603,1200,470,370,803,933,1556,476,491,1089,921;34;F
94921;491,398,352,331,225,359,538;35;M
95042;1632,1313,331,1108,1355,1101,538;36;M
95214;1603,225,331,358,460,1200,470,359,1556,1101,491,921,724,933,476;35;F
95234;1632,1313,1200,1108,933,1355,1089;38;F
95265;1603,933,921,370,359,460,225,1200,159,470,803,1556,476,1101,491;37;F
95409;1089;25;F
95429;1313,806,159,605,476,921,603,331,491,1724;36;F
95438;460,1313,760,225,470,370,1556,603,1101;31;M
95439;538;40;M
95446;460,1313,381,470,370,804,724,933,1556,1355,476,491,398,548,921;36;F
95472;1313,1108,1355,1101,538;71;F
95518;359,603,1355,352,803,933,1556,476,1101,491,1709,1089,604,1724,921;26;M
95535;225,1200,370,359,476,491,921,933;23;F
95641;460,358,225,1661,470,370,803,933,1556,1355,476,491,238,1089,921;41;M
95650;460,1313,1632,331,1603,370,803,359,1556,603,476,491,604,1724,921;39;F
95679;370,1266,933,1556,476,491,1709,548,1724,921,352,1632,460,358,225;26;F
95691;1089,933,548,1632,359,352,331,225,1603,1200,1556,476,1724,921;36;F
95699;225,460;36;M
95715;352,1724,921,491,1663,1313,1556,933,803,370,470,1200,225,460,476;21;M
95779;1370,943,1651,395,238;73;F
95795;921,1632,358,331,225,799,1603,1370,605,724,603,1101,805,238,1089;20;F
95827;1632,460,358,225,1200,470,370,359,933,1556,476,491;24;F
95845;1556,1089,1603,1661,398,1101,159,1632,381;33;F
95897;1313,1108,1355,1101,538;39;F
95901;491,476,470,1200,225,1266,605,933,1313,799,804,604,359,460,724;41;F
95923;943,1661;24;F
95926;331,1200,803,476;31;F
96018;1313,460,225,470,370,724,933,1556,476,1101,491,921;47;M
96079;802,476,1200,1603,331,1606,159,1556,395,603,805,548,1089,1724,921;43;M
96116;804,548,352,805,1556,933,1313,1603,1108,359,1355,1101,538;68;M
96191;933,603,604,1089,921,352,358,1603,159,370,803,1101,491,238,548;29;F
96203;1632,1606,331,225,1200,1556,352;41;F
96248;538;29;M
96249;1556,933,817,1603,225,460,470,370,603,853,491,921,476,398,238;44;F
96394;1313,1108,1355,1101,538;28;F
96492;1313,1108,1355,1101,538;23;M
96497;395,470,225,460,331,1200,370,803,1556,476,1101,491,1089,921,538;30;F
96617;460,331,225,1603,806,159,470,1556,921,1632,1200,803,476,1101,491;28;M
96696;460,358,331,225,1200,159,470,1108,803,359,921,1556,1355,476,1101;15;M
96697;1313,1108,1355,1101,538;29;F
96702;381,1370,1651,352,1355,359,370,1603,1632,331,225,1200,470,803,1556;40;F
96711;1709,1724,921,1603,225,1313,1632,460,331,381,933,1556,476,398,352;33;F
96800;1200,1603,225,331,1606,358,799,801,1108,1556,491,548,238,370,1632;40;F
96821;1370,943,1651,395,238;67;F
96833;1313,1632,1108,1355,1101,538;83;M
96835;538;46;F
96897;1632,1313,1355,1108,1101,538;60;M
96924;238,1724,352,1603,460,225,806,370,1266,1651,803,933,491,921,358;45;M
96975;331,159,470,370,1101,491,1089,921;34;F
96994;1370,943,1651,395,238;78;M
97006;1632,460,331,225,1603,1200,370,1108,476,491,921;31;F
97035;1663;31;M
97041;1663;30;F
97084;1200,1370,1266,1556;53;M
97094;538;22;F
97097;460,817,801,370,1108,933,1709,1089,1632,1603,1661,803,1556,491,538;44;F
97134;331,1200,359,933,1556,476,1089,491;34;M
97238;225,460,760,1661,1606,331,1603,1370,359,933,476,491,1709,1089,921;33;F
97249;538;48;F
97269;1370,943,1266,1651,359,395,238;66;F
97275;801,359,1556,603,476,1603,1089,238,331,370,933,1370;32;F
97533;238,331,1632,225,806,1200,1370,817,1266,1108,803,1556,476,1101,538;15;F
97633;603,476,491,1709,1089,921,1632,358,331,1603,1200,470,370,933,352;46;F
97729;804,724,603,491,805,460,331,225,1603,1200,470,476,1089,238,921;34;F
97773;1370,943,1651,395,238;76;F
97793;159,933,395,1556,921,352,460,1313,225,1200,470,370,476,491,1089;27;M
97867;460,1313,225,1200,470,476,1101,491;31;M
97987;1200,470,370,1108,359,724,460,358,933,352,331,225,1603,476,491;54;M
98094;476,1663;28;M
98113;1370,943,1651,395,238;74;F
98272;1355,1709,1724,352,460,225,1603,1200,470,1108,603,476,1101,491,921;31;F
98275;1313,460,760,1370,1661,1266,1651,1556,1355,1101,398,238,604,538;11;F
98276;225,1556,491,1089,358,1313,802,1266,359,476,1101,1709,921,352,1724;20;M
98366;460,760,799,1661,370,1266,1651,724,1355,1101,398,238,604,538;8;M
98453;802,803,359,491,370,933,548,225,1101,921,331,1603,476,352,1089;50;F
98483;1632,806,803,359,352;51;M
98538;1200,1370,1266,1556;64;M
98540;538,476,225,1632,331,806,1200,1370,817,1266,1108,803,1556,1101,238;13;M
98549;225,1370,1266,1556,1101,398,604,538;43;M
98881;1200,331,225,1370,1661,802,370,1266,359,933,395,476,491,238,1089;8;M
98882;1632,1606,1089,331,225;73;F
99063;603,538;13;F
99108;1200,1370,943,801,1661,802,1266,1651,395,476,238,921,352;45;F
99167;603,538;17;M
99173;460,1355,277,805,1709,921,605,853;31;F
99236;1200,802,370,803,724,933,1556,395,476,1632,1370,1651,238;17;F
99294;352,802,803;29;M
99295;921,548,1709,1101,1355,1556,803,370,460,801,470,933,476,491,1089;25;M
99298;1313,460,331,225,1200,159,370,1108,803,1355,491,805,238,921,352;38;F
99344;538,352,470,359,460,358,225,1200,801,603,1101,238,921,1724,1089;47;F
99367;352,359,470,1200,1603,331,225,460,803,933,1556,476,921;38;M
99369;603,538;45;M
99370;331,225,1603,1200,470,370,1266,1556,395,1355,476,491,238,1089,921;25;M
99378;470,803,359,933,1556,603,476,548,1724,491,1632,331,1200,370,1089;33;F
99383;1632,331,225,1603,806,1200,470,803,359,933,1556,476,491,1089,921;57;F
99386;604,1266,724,1556,395,921,225,1603,933,1355,476,331,1200,470,352;33;F
99418;358,603,853,476,277,491,805,548,238,1089,921,538,1313,359,352;30;F
99546;359,921,460,225,1603,1200,1370,470,370,933,1556,1355,476,1101,491;39;M
99589;1313,460,331,225,1200,470,370,359,933,1556,1355,476,491,538,352;62;F
99598;933,476,491,398,1089,604,921,1632,1606,331,225,1603,1661,1108,359;26;F
99642;358,225,1200,159,370,359,933,476,1101,491,352;32;M
99694;331,358,1603,802,159,277,548,724,933,1556,603,853,476,1089,1632;43;F
99777;460,225,1200,943,470,370,1108,1651,933,1556,476,491,238,538,921;54;F
99790;238,801,1266,802,476;37;F
99809;803,359,933,1709,1101,548,1089,921,370,225,331,1313,476,491,352;26;F
99863;1632,1663,159,760,460,358,225,470,370,359,933,476,491,921;39;M
99902;460,1603,803,1556;35;M
100006;238,1632,1313,460,225,1200,803,359,724,1556,1355,476,491,1101,538;54;F
100044;603,805,1556,724,359,803,1108,370,159,1200,1603,225,358,921,352;38;F
100052;1651,476,491,1089,1313,1606,1370,817,801,1266,804,359,398,238,352;47;F
100053;1370,943,1651,395,238;66;F
100081;605,724,933,1556,395,603,1355,476,1101,398,805,1089,604,921,538;51;F
100214;476,277,491,1089,604,760,724,1632,603,238,359,1651,159;54;F
100250;1632,460,225,1603,1200,1370,943,159,1661,1651,1108,933,603,1101,238;16;F
100334;1089,352,358,460,331,225,1603,1200,801,803,1556,476,491;35;M
100342;802,1313,460,1606,331,225,1200,159,359,933,603,476,491,548,1089;29;F
100346;803,1313,460,331,1200,159,470,370,359,724,933,1556,476,491,921;25;F
100380;1313,359,1556,460,225,1200,470,605,933,1355,476,491,1089,1724,921;13;F
100439;1709,604,760,491,921,460,1632,225,1200,1661,801,548,331,1603,352;40;F
100467;799,760,358,921,604,277,603,933,804,1266,1606,331,1603,1661,359;29;F
100469;352,921,1101,1556,359,470,1603,460,331,225,1200,933,476,491,1089;31;F
100507;1632,1603,1651,359,933,1556,395,491,1370,943,803,476,1101,805,238;48;F
100530;1313,1603,1200,1661,933,1556,476,1101,491;32;M
100569;1108,370,801,1661,817,1370,1200,1603,381,760,238,921,1651,1101,491;28;M
100573;331,921,370;41;M
100574;1101,806,1200,470,370,1108,933,352,1556,1355,476,803,491,1603,331;37;M
100604;1606,470,1101;39;F
100739;933,370,1200,225,460,331,1603,470,803,1556,476,491,1089,921,352;36;F
100797;799,1603,1200,225,358,460,381,803,1556,476,1101,491,1709,1089,921;25;F
100859;921,548,491,476,1355,1556,359,803,370,470,225,381,760,358,460;28;F
100935;1313,358,1370,801,159,331,1632,476,225,921,359,460;32;M
100948;331,1603,1606,1200,470,370,1108,803,933,395,476,921,1089,1101,548;44;F
100997;1200,1661,801,476,491,1651,1108,803,724,395,603,277,805,238,604;37;M
101056;1313,1101,159,1200,460,331,225,1603,817,1661,470,1556,604;41;M
101091;538;14;M
101099;358,538,921,1089,476,603,370,460,225,1200,359,933,1101,491,352;30;F
101176;359,933,1556,921,538,352,1089,805,491,1355,1313,331,1603,370,1266;64;M
101199;370,352,238,1651,1663,1661,1200,1603,1632,1313,1108,1101,1709,921,476;31;M
101208;805,803,802,799,724,933,381,225,277,358,352;38;F
101294;352,331,225,1603,359,933,476;27;F
101354;1556,933,358,352,1313,460,331,225,1603,1200,1355,476,491,1724,921;39;F
101471;476,1101,491,548,1089,921,538,352,358,806,159,1313,225,470,803;37;F
101482;1556,370,470,460,331,225,1603,1200,803,933,491,1089;30;F
101485;603,476,1101,491,805,921,352,398,1556,359,1108,470,943,1603,331;9;F
101494;470,359,476,352;37;M
101513;1632,1313,1603,1200,817,1661,802,470,1651,933,1556,853,476,491,604;63;F
101518;538,921,548,805,1101,603,1556,724;24;M
101565;460,225,1200,470,370,359,933,1556,603,476,1101,491,921,352;44;F
101571;801,470,370,359,933,491,352,225,724,1556,603,853,476,548,921;29;F
101638;470,225,1200,933,476,491;36;F
101671;538,1724,548,853,225,1632,370,605,1101;27;M
101676;1101,1606,1603,1200,1370,1651,1556,1709,238,1089;29;F
101819;1632,159,801,803,933,603,1355,476,1101,491,805,238,1089,921;30;F
101830;1556,933,1200,1603,358,921,1089,1101,476,470,225,603,1108,1632,331;35;F
101877;370,801,1661,817,460,1370,331,1200,470,1556,476,491,1089;39;F
101901;1108,853,921,603,1101,491,548,1089;42;F
102037;801,470,1663,370,1266,804,395,476,548,1089,921,1632,331,1603,1200;36;F
102106;1632,1606,331,801,802,1663,605,803,724,603,853,805,548,1089,538;31;F
102111;352,921,548,491,605,817,1603,331,460,1632,1313,225,933,853,476;68;M
102346;352,921,491,1101,933,1200,331,225,803,1556,476,1709,1089;26;F
102347;1632,1370,1108,933,1101,921;39;F
102351;370,1370,381,460,1632,760,159,1661,470,1663,1266,804,1556,1355,476;32;F
102479;1632,921,1089,359,803,1266,470,331;24;F
102515;603,1313,460,331,225,1603,1200,470,370,804,933,1556,395,476,805;43;F
102572;1266,803,359,724,933,476,491,1709,460,1200,805,604,1724,352,1355;35;M
102618;933,802,1370,1606,799,460,1313,1632,225,370,1266,1651,1108,476,491;41;F
102625;277;22;M
102650;853,921,724,1108,802,817,1200,225,331,460,1603,159,1101,805,1089;30;F
102701;1089,604,460,1606,1603,921,352,470,225,1313,159,358,331,853,359;41;M
102813;470,159,1200,1603,225,358,460,806,803,724,1101,491,548,1089,921;29;F
102823;1556,1355,358,331,806,1370,802,803,933,724,476,1101,491,238,1089;22;M
102842;1313,1606,1603,1200,1661,1089,352,933,1556,476,1101,805,548,604,921;51;F
103046;760,1632,1313,460,331,225,1200,817,1556,358,370,803,359,933,603;37;F
103058;491,1603,225,1606,460,331,803,933,476,1101,1089,603,370,358,352;30;F
103061;1200,1370,943,159,802,1663,1651,803,1556,395,476,1101,1709,238,352;77;F
103075;1632,1101,476,1556,724,370;31;M
103116;1556,398,238,1089,460,358,225,470,370,359,724,933,476,491,921;10;F
103223;1313,460,331,225,470,370,933,476,491,921;43;F
103282;921,548,603,1556,359,470,1603,460,225,1200,803,933,476,491,352;33;M
103342;460,806,1200,470,370,1266,933,1556,1355,476,491,805,238,921,538;30;M
103465;470,370,1108,803,359,933,1556,603,1355,476,277,491,238,1089,538;17;M
103616;476,1101,398,1632,1313,331,381,1200,1370,1266,804,605,805,1709,238;36;M
103619;1603,1200,1556,491,933,331,460,370,470,225,1313,476,921;44;M
103629;460,470,370,491,1089,1724,352,921,476,1556,933,803,1200,1603,225;49;F
103840;943,359,933,1556,491,1089,921,225,1632,460,159,470,370,476,352;44;M
103963;331,470,1651,803,603,352;35;F
103984;331,1101,476,359,921,1108,1200,460,470,803,1556,225,1603,538,352;67;M
104035;1661,1355,476,277,398,805,724,1108,1266,1370,225,358,548,238,538;10;M
104160;1313,1632,1108,1355,1101,538,1661;63;F
104212;476,1556,1603,331,603;27;F
104316;277,1313,460,799,1266,604,225,470,359,724,933,476,491;36;M
104339;1661,801,1108,724,277,491,352,802,538,358,605,1556,603,805,238;53;F
104346;1200,1370,1266,1556;40;M
104533;491,1709,1724,921,1632,1313,1606,331,1603,1200,803,933,1556,395,1089;29;F
104534;1632,1313,460,470,476;41;F
104540;1603,806,159,1556,1709,225,1200,470,370,933,476,1101,491,1089,921;30;M
104572;1266,1108,359,1556,1101,604,352,538,358,799,159,1663;26;F
104644;1632,1200,1370,470,803,933,1556,603,476,238,921;13;M
104648;1266,603,805;47;F
104673;1370,817,604,352,1089,805,603,395,1556,1266,1663,470,801,1661,803;20;F
104718;1632,1200,1266,1108,359,603,476,1101,1089,352,358,1313;45;M
104770;225,1200,470,370,359,1556,476,491,1724;59;M
104775;760,724,805,476,1355,1108,1266,1661,1370,225,358,277,548,238,538;14;F
104838;803,358,381,1266,805;52;M
104861;806,799,225,381,331,1606,760,358,460,1313,1632,1101,352,1724,921;19;F
104900;853,805,1266,1108,803,1355,398,604,1606,331,1661,801,1101,538,352;39;M
104935;1313,352,1200,1632,460,358,225,470,370,359,933,476,921,491;25;F
105006;358,331,1603,799,1370,817,238,1108,1709,604,802,804,1089,352,1661;48;F
105045;1663;46;F
105049;352,1632,381,1603,1370,359,1556,395,805,238;47;F
105059;1632,460,1606,331,225,1603,1200,470,933,603,476,1101,491,1089,921;49;F
105088;799,1603,1663,1266,1709,491,1355,359,1661,1370,1606,460,358,1313,1632;30;F
105135;1606,331,225,1603,1200,1556,476,548,1089,921;77;F
105166;331,1370,470,933,1556,476,491,398,1724,1089;47;F
105264;802,1200,460,358,1606,331,225,1603,1370,470,370,933,476,921,491;36;F
105276;1313,806,470,1556,921,331,225,1603,1200,370,1651,1632,460,1370,476;45;F
105309;460,1606,225,470,370,359,933,476,491,921;36;F
105380;491,1101,803,1108,1200,460,476,331,225;33;M
105384;921,1556,358,370,476,933,491,225,460,470,359;37;M
105414;1606,1632,331,1603,1370,817,1661,1651,1108,933,1556,476,548,238,921;28;F
105424;1632,1313,460,381,238,398,603,804,470,1370,1266,1101;33;F
105427;1200,802,470,370,1108,359,933,1556,476,1101,491,805,548,238,352;32;F
105471;1606,331,225,1603,1200,817,370,803,1556,476,491,238,1089,921,352;42;F
105486;460,1632,225,1603,470,370,359,933,1556,476,1101,491,921,352,159;27;F
105558;358,806,803,1355,1101,805,548,238;36;F
105574;1089,238,548,491,476,603,1556,933,1266,358,1632,225,470,370,803;29;F
105594;1603,1200,1370,1661,470,370,1266,1556,395,476,491,921,159,803,1101;49;F
105658;359,933,1556,1355,476,491,1101,398,805,1709,1089,1724,921,538,352;61;F
105730;359,724,933,476,1101,548,1089,1632,331,1603,1266,803,1556,491,538;33;M
105754;933,225,1632,331,470,370,359,1556,476,491,921,352;41;M
105881;331,225,1603,1200,491;22;F
105882;1556,1355,921,1089,238,548,398,491,476,1724,603,1101,1709,538,352;38;F
105885;1355,1108,1632,460,358,225,1603,1200,802,470,370,803,933,476,491;34;M
105920;1313,460,225,1603,1200,1370,801,470,370,803,933,1556,476,491,921;26;F
105954;1632,1313,460,470,1108,1556,331,225,1603,1200,1661,370,803,476,491;27;F
105956;803,1355,1101,352,331,460,1313,921,491,476,1556,933,370,470,1200;36;F
105982;1632,1606,1661,801,802,803,359,395,603,853,1101,805,548,1089,1724;34;F
106104;460,225,1603,1200,470,370,724,933,1556,476,491,921;25;M
106115;803,933,1556,1355,476,398,805,538;43;M
106116;1603,801,470,370,803,933,1556,1101,491,225,1200,1108,476,921,352;29;M
106165;804,1266,1663,1632,358,1313,1108,1355,1101,538;38;F
106173;1603,805,1266,803,1556,476,538;36;F
106229;1632,460,1603,806,1370,943,1651,1556,476,277,238;20;M
106250;460,331,225,1603,806,1200,470,370,933,1556,476,491,921;5;M
106317;806,358,1313,460,225,1603,1200,470,803,933,1556,1355,476,491,921;33;F
106381;1101,1355,1556,803,1663,331,460,225,1603,1200,359,933,476,491,1089;34;M
106425;460,358,225,470,370,359,724,933,476,491,921;33;M
106482;460,358,225,470,370,359,724,933,476,491,921;49;M
106491;159,470,1108,933,1556,476,1101,491,548,1089;33;F
106499;760,352,1355,460,1313,331,470,370,1266,476,1101,491,1709,1089,1724;19;F
106502;805,1266,370,395,603,476,352,358,817,1661,238,1632,1370,1089,921;30;F
106506;921,760,352,1355,1313,331,470,370,1266,476,1101,491,1709,1089,1724;23;F
106615;460,1661,603,1355,805,225,799,1663;42;F
106623;460,225,1200,817,470,933,1556,603,476,491,331,802;25;F
106747;225,806,1370,803,359,933,1556,1355,1101,491,238;2;F
106802;1632,358,331,1603,370,933,476,1101,491,1089,921,460,225,159,1108;32;M
106841;538,921,277,476,853,933,358,331,801,370,724,1556,603,491,1089;23;F
106844;460,331,225,1603,1200,470,370,1108,359,933,1355,476,1101,491,921;22;F
106908;460,331,225,476;47;F
106946;1101,225,1709,1370,1651,1663,370,1089,1632,460,359,933,476,491,238;64;F
106957;921,358,933,491,460,370,225,1200,470,476;30;F
107016;1370,1632,331,1603,1200,1661,1266,804,803,933,1556,1355,476,1709,1089;49;F
107028;381,1603,1200,817,159,1661,470,1663,370,1266,1556,1089,604,921,538;32;F
107108;1632;39;M
107176;921,491,476,933,359,370,470,225,460,358,803,1101,1651,238,802;37;M
107344;1370,1606,1313,1632,460,331,225,1603,1200,1663,476,491,604,921,352;34;F
107388;1313,1200,799,802,1266,803,853,238;26;M
107437;225,460,1313,331,1603,1370,470,370,933,1556,476,1101,491,238,921;29;F
107473;806,1632,358,1661,1108,1101,1709,548,238,225,470,370,1556,491,921;29;F
107529;460,225,1603,1370,1661,470,370,359,476,1089,352,331,1266,803,491;40;F
107566;381,1661,1266,804,1108,476,604,1313,331,1200,1370,470,1556,1101,398;30;F
107567;1313,1108,1355,1101,538;57;M
107577;476,1108,470,225;29;F
107595;395,359,605,1651,1266,358,225,1200,470,1108,724,933,476,491,1089;36;M
107689;1632,331,1200,1108,1556,476,491;36;M
107800;159,801,470,370,476,1313,491,1089,921,943,1661,238,331,760,817;31;F
107894;933,1101,921,1724,548,491,476,724,1651,1266,370,470,225,1632,1089;25;M
107920;358,933,460,331,225,1603,806,1200,470,370,803,1556,476,491,921;40;F
108120;921,491,1089,1724,460,1603,806,1200,470,370,359,933,1556,476,352;39;M
108121;548;24;F
108197;1313,1108,1355,1101,538;63;M
108200;1606,1603,331,460,225,470,370,933,476,491,359,921;30;F
108214;1370,943,470,1266,1651,803,933,395,476,491,805,238,1089,604,921;41;F
108221;470,1651,1632,760,1200,801,1101,548,604,921;35;F
108247;538;47;M
108331;803,1606,460,331,225,1603,806,1200,470,370,933,1556,476,491,921;37;M
108349;804,359,476,238,352,358,331,1200,943,1663,803,933,1101,277,491;31;M
108384;1709,548,1089,1724,921;54;M
108467;358,491,1632,331,225,1603,1200,803,933,1556,476,1101,1089,921,352;66;M
108473;358,491,1632,331,225,1603,1200,803,933,1556,476,1101,1089,921,352;66;F
108524;1313,1108,1355,1101,538;39;M
108561;1632,1603,1200,921,724,352,491,1101,359,370,470,803,933,1556,476;49;F
108566;370,460,1355;45;M
108668;1200,1370,1556,398,238,225,933,476,921;41;F
108958;225,1606,331,159,470,370,803,933,1556,395,1355,476,491,1089,921;24;F
108991;1632,817,801,1266,804,359,724,921,331,381,1661,1663,1709,1089,352;29;F
109000;358,225,1200,1370,817,943,1661,1651,803,395,476,805,238;43;M
109027;1724,1651,1661,801,470,817,1200,1603,1370,1709,238,225,460,370,1355;38;F
109046;1089,1355,933,803,470,159,1200,1603,1632,331,225,1556,603,476,491;38;F
109074;1724,921,491,1101,476,1355,1556,933,803,370,470,1200,225,358,460;39;M
109119;1663;46;F
109182;1200,470,370,803,933,1556,491,1089,921,460,331,225,1603,476,352;40;F
109196;806,398,803,1266,1313,1355,1101,538;41;M
109216;352,921,803,370,470,331,1606,358,225,1603,1200,933,1556,476,491;45;M
109274;1556,331,1632,1200,370,491,921,460,358,225,470,359,724,933,476;36;M
109286;331,225,1603,1200,817,943,1661,801,470,370,933,1556,476,491,921;36;F
109372;460,358,225,470,370,359,724,933,476,491,921;43;M
109384;460,1313,1661,491,1709,853,1108,1651,802,1370,358,1632,724,548,238;18;F
109391;1603,460,358,225,470,370,359,724,933,476,491,921;36;M
109472;1632,1603,801,470,370,803,359,933,1556,395,476,491,1089,1724,921;25;F
109485;460,1313,1606,225,1200,470,370,1108,803,933,491,1709,1089,1724,921;25;F
109539;1603,331,1313,359,1606,1632,470,1663,1556,476,398,491,1709,548,921;27;F
109622;470,1370,491,352,225,1661,1651,804,476;45;F
109643;370,331,460,225,1603,470,1556;27;M
109663;352,933,1200,470,370,460,331,225,1355,476,921,491;28;F
109672;331,225,806,1200,817,1370,803,933,1556,476,491,238,1089,921,352;72;M
109754;491,395,359,804,1266,802,1603,460,225,1200,470,1556,933,476,921;42;F
109774;1313,460,1200,1370,470,370,803,359,724,1556,603,476,1101,238,921;34;F
109799;358,1632,225,1603,1200,802,803,359,933,1556,476,1101,491,238,921;40;F
109824;1370,943,1651,395,238;65;F
109832;1266,381,760,1313,1632,460,358,1606,331,1603,603,476,1101,491,548;27;M
109861;1603,1651,1355,548,238,1089,331,470,1101,1661;32;F
109875;802,370,1651,1108,933,1101,1370,159,1266,359,1355,805,238,1089,352;42;F
109915;1632,802,1108,1355,538;36;F
109973;491,1313,460,331,225,817,1661,802,1266,804,1709,1089,604,1724,352;52;F
110067;491,1101,1709,1724,921,352,358,1370,817,359,603,853,476,805,238;34;F
110087;1370,491,359,933,1556,603,395,476,538;36;M
110104;1313,331,943,470,476,491,921,1200,1603,225,460,358,1632,1606,1556;28;F
110139;358,1556;30;M
110205;460,358,331,225,1603,1200,1108,476,491,1556,470,921,352,1089;33;F
110212;1632,460,358,225,1200,470,359,933,1556,1355,476,491,921;19;F
110236;1632,1313,358,331,1603,1200,159,1651,933,1556,395,476,238,1089,538;26;F
110281;460;34;M
110315;1313,460,225,1603,1200,933,1556,491,921;27;M
110414;1632,1606,1200,470,803,1556,1101,476,933,1603,225,460,331,491,1089;42;M
110422;933,1556,1355,491,352,225,1200,470,359,724,476,1101,548,921,538;39;M
110458;1089,460,1632,1313,331,1603,1200,1370,359,476,805,238,1724,921,352;58;F
110459;470;39;M
110471;933,853,805,460,1606,331,225,1603,1200,803,1556,476,1101,548,1089;32;F
110489;1632,460,331,806,225,1200,470,370,803,933,1556,1355,476,491,921;41;M
110665;1632,460,358,1603,277,491,604,921;70;F
110684;724,1101,805,538;34;M
110704;1632,1313,460,225,1603,470,370,933,476,1101,491,921,352;24;F
110711;1651,358,460,1632,1313,331,1603,1370,1661,1556,1355,1101,548,1089,238;37;M
110726;803,1200,817,225,331,806,1370,943,1651,395,476,238,1089,921,352;70;F
110732;460,1606,225,799,1603,1108,605,803,603,476,398,805,1089,604,538;65;F
110781;359,802,803,476;58;M
110832;1556,460,799,1603,1661,359,724,1632,1606,331,801,370,1266,1089,538;57;F
110929;370,395,491,1089,460,225,1603,1370,159,1651,359,603,238,921,352;34;F
110982;1108,1603,331,460,352,476,1556,359,1266,470,225,1632,1355,1101,538;46;F
111000;1313,1632,943,921,1603,1200,933,476,491,1663;36;M
111016;491,1089,352;40;F
111046;460,225,470,370,1266,803,933,1556,476,491;44;F
111065;1661,1108,803,724,933,1101,1089,331,225,159,801,370,359,1556,491;41;M
111068;1556,359,803,1661,460,358,1606,331,225,1603,1200,159,476,1101,1089;39;F
111083;352,1200,359,803,225,1313,331,1632,1661,1101,1556,933,476,1108,470;30;M
111091;476,1632,460,817,1370,943,802,803,933,1556,491,238;23;M
111092;331,802,358,1632,460,1200,817,470,370,1651,359,238,1089,476,921;32;M
111143;1632,225,1603,1200,470,1663,803,933,1556,476,491,238;36;M
111163;1266,933,1556,491,398,921,352;41;M
111185;1556,933,225,1603,1108,605,803,359,724,476,398,805,1089,604,538;69;M
111213;395,1556,1370,331,460,358,225,470,370,359,724,933,476,491,921;47;M
111262;1632,358,331,225,1370,1200,370,803,933,1556,476,491,238,921,352;41;F
111283;460,1606,331,225,1603,470,370,359,933,476,491,921;33;M
111284;358,933,921,460,225,1200,1661,470,370,359,1556,476,491,352;35;F
111288;1556,1101,1200,803,358,225,470,370,359,724,933,476,491,460,921;41;M
111348;352,1663,359,803,605,804,802,1661,1370,1200,1603,225,799,460,1313;25;F
111381;1709,1313,1632,1603,1661,370,1266,1556,603,476,1101,491,1089,1724,921;26;F
111383;1313,331,806,1200,804,1651,921,352;53;M
111390;933,853,1603,381,1632,1606,1108,352,331;37;F
111399;538;21;F
111436;460,358,225,470,370,359,724,933,476,491,921;37;M
111439;804,370,801,225,1632,1606,331,1603,817,159,1661,476,491,1089,921;36;F
111440;1200,1370,1266;21;F
111470;1603,1661,801,803,1556,603,853,1089,1632;30;F
111480;1651,1266,1663,802,801,1661,331,760,358,724;41;F
111484;331,1603,1370,803,395,1101,460,225,1200,470,933,476,491,921,1556;40;M
111494;225,1370,1266,398;36;F
111530;395,352,460,331,1603,1200,159,370,803,1556,476,1101,491,1089,921;29;F
111596;1663;28;F
111614;370,1632,358,1603,1200,802,1266,803,476,398,805,1089,921,352;37;F
111675;724,359,470,225,460,358,933,476,491,921;50;M
111681;803,603,398,805,460,358,225,470,370,359,724,933,476,491,921;51;F
111691;470,1603,225,460,1313,352,921,476,359,1108,760,1632,331,1200,1089;30;F
111750;1556,804,470,1661,1313,1632,1266,1108,359,933,476,491,238,921,352;63;M
111780;1355,1313,1108,1101,538;60;M
111824;933,921,491,1200,470,370,1108;43;M
111847;538;41;F
111898;921,1313,225,1200,491,352;45;F
111899;1313,1108,1355,1101,538;74;M
111977;331,225,1603,1200,1661,370,803,359,1355,476,1101,491,1709,1089,921;43;F
111990;1663,943,225,1606,460,1603,1200,470,803,933,1556,476,491,1089,921;24;F
111994;921,1606,1266,933,476,238,460,1603,1200,1370,1661,370,803,1556,1355;70;M
112002;331,1089,470,370,724,359,1200,460,1632,817,159,225,476,491,921;35;M
112004;933,1355,476,460,225,1200,921,491,238,1632,331,1603,1663,1556,1101;44;M
112020;460,225,933,603,476,548,538,1200,159,470,370,1355,1101,491,921;29;F
112023;331,1603,933,476,1651,605,803,359,395,352,159,1556,491,548,238;31;M
112083;225,1313,460,470,603,476,491,398;12;F
112095;801,1603,1663,1089,921,476,1606,1632,760,331,225,943,159,802,853;32;M
112152;1355,1101,491,370,933,476,921,460,1606,225,1603,159,470,1632,1663;41;F
112175;1632,933,460,331,225,1603,1200,470,370,1556,476,491,398,238,921;37;F
112216;853,370,470,943,1200,460,1632,331,817,159,476,548,1089,491,921;33;F
112267;1606,331,1603,1370,1632,943,1661,802,470,1651,1556,603,491,238,1089;64;M
112324;933,548,331,1603,1355,381,817,943,1651,853,1101,799,1370,238,803;43;F
112387;603,548,1709;40;F
112519;1313,1266,804,491,398,538;37;F
112521;1313,1632,460,331,225,1603,1200,470,370,933,1556,1355,476,491,921;38;M
112574;1089;46;F
112575;1370,943,1651,395,238;67;M
112580;460,331,1200,1556,491,921,1632,799,1370,817,370,803,853,548,1089;36;M
112684;1313,460,225,803,933,1556,1355,476,491,921;31;M
112704;1606,331,225,470,1663,1108,1709,921,352,1370,817,1556,476,491,548;25;F
112796;1355,460,358,331,225,1603,1200,370,933,1556,476,1101,491,1089,921;32;F
112818;1313,1632,331,225,1603,1200,470,370,933,1556,603,476,491,398,921;2;M
112846;817,1200,1603,225,331,1606,460,1632,1313,358,470,370,1101,491,548;31;F
112931;1200,352,225,358,476,238,921,933;42;F
112935;1661,801,802,1663,470,370,803,1355,476,1101,491,398,921,804,1266;68;F
112967;538;39;M
113014;802,1606,1603,331,1661,1266,853,548,358,1370,943,803,238;47;M
113017;395,1724,921,225,460,1313,331,1370,803,933,1556,1355,476,491,1089;33;F
113117;1632,460,331,225,1200,159,470,370,933,1556,476,1101,491,1724,921;29;F
113183;921,225,470,476,491;36;M
113192;225,799,476,359,358,470,370,491,805;37;F
113194;1108,370,1661,802,225,491,921,460,1632,331,1603,1200,395,603,476;45;M
113212;538,277,724,358;29;F
113263;1632,358,331,225,799,1200,370,1556,476,1101,491,548,921,853,1603;25;F
113269;470,724,1556,238,1632,1313,331,370,359,603,491,1709,548,921,352;31;F
113295;1108,933,1724,1089,803,1200,1355,1651,1101,1661,1313,1632,1603,1556,921;61;F
113325;1313,225,933,1556,476,1101,491,921;36;F
113368;1632,331,359,358,225,1603,1200,159,803,1556,476,921,352;32;M
113369;803,1089,460,921,225;39;F
113382;331,1200,470,803,921,370,460,1603,225,358,933,476,491,238;43;F
113414;1370,460,358,331,225,1603,1200,370,933,1556,395,476,491,1089,921;2;M
113502;1313,1632,1200,1101,1089,921,352,460,225,470,933,476,491,548,238;34;F
113557;381,799,1663,603,491,805,238;31;F
113574;603,853,1355,805,538,605,604,804,1266,799,398;39;F
113592;1370,817,853,331,381,803,476,805;46;M
113621;225,1556,352,921,1200,1089,470,331,1313,359,476;41;F
113672;1200,1603,331,460,358,225,470,370,359,724,933,476,491,538,921;23;M
113757;1556,1709,1724,1370,1661,1606,331,801,359,1089,921,352;34;F
113837;225,802,803,470,359,352,1606,460,331,1603,1661,943,370,933,491;23;M
113838;159,352,921,548,1632,460,331,225,1200,470,370,933,603,476,491;32;F
113854;1313,331,225,1200,359,1101,548,1089,352,1603,1108,724,1556,603,476;36;F
113867;1089,359,1606,476,331,460,225,1603,1200,470,370,933,1556,491,921;66;F
113919;1101,460,352,225,1632,1603,1200,470,370,803,1556,476,491,1089,921;76;F
113930;359,933,1556,460,225,1603,1200,470,370,476,491,352,921;41;M
113954;370,1266,476,491,805,921,604,1089,603,724,801,381,331,460,1313;23;F
113968;460,358,225,470,370,359,724,933,476,491,921;20;M
114012;1313,1108,1355,1101,538;60;M
114072;1200,331,460,358,225,470,370,359,933,476,491,921;41;M
114126;538;48;M
114139;1632,1370,943,548,238;30;F
114167;1632,331,381,802,605,803,1556,603,476,1101,491,548,1089,921,352;37;F
114227;225,1603,1200,370,359,476;38;F
114241;370,395,724,1355,398,604,1632,943,1661,1266,1651,1101,491,238,921;17;F
114279;806,1606,1313,460,476,352,331,225,801,470,370,359,491,1089,921;33;F
114298;1313,358,1606,331,159,370,1101,491,1089,921;38;F
114338;921,1556,933,359,370,470,159,331,460,1632,225,806,1200,803,476;32;F
114387;358,1200,359,225,470,724,491,921,538,352,460,159,370;27;M
114436;1313,1108,1355,1101,538;12;M
114483;1724,1355,359,1651,370,470,1370,1603,225,460,1200,476,491,921,352;36;M
114488;159,802,933,491,548,921,1200,1603,225,470,603,476,1101,1089,352;37;F
114498;1370,1266,359,933,1101,1632,331,381,1603,370,1108,803,1556,476,491;40;M
114538;803,921,1200,1603,331,460,1651,1108,933,1556,395,476,1101,238,1370;45;F
114541;538;7;F
114565;1200,806,1603,225,358,460,1313,370,803,933,1355,476,491;23;F
114572;476,1089,921,460,1632,803,470,1200,806,1603,225,331,724,933,1556;35;F
114579;331,1632,1200,159,370,1651,803,359,933,1556,395,476,1089,921,352;26;F
114593;933,359,1603,331,1200,1556,476,1089,921;41;M
114641;1632,470,1108,359,933,724,603,476,1101,491,548,238,1089,604,921;28;F
114675;1089,1632,460,358,331,225,1603,806,1200,803,724,933,1556,476,1101;39;M
114698;331,470,491,1632,1313,460,225,1603,1200,801,1108,933,1556,476;37;F
114705;605,370,817,1370,799,760,1661,802,1266,804,1108,277,1709,604,538;11;M
114749;460,358,225,1200;26;M
114788;1313,760,1108,1355,1101,538;42;M
114807;1089;39;F
114844;225,605,803,724,933,1556,331,470,476,921,491,1313,1108,538,1101;38;F
114891;225,943,331,799,159,802,605,603,853,277,1101,805,548,1089;29;F
114892;331,1603,1200,370,359,803,1313,225,358,470,1556,476,491,548,921;37;M
115015;1632,331,225,1603,1200,1370,803,933,1556,603,476,491,1101,238,1089;21;F
115026;803,470,1200,1632,460,1606,331,225,1603,370,359,1355,805,1709,352;40;M
115149;799,381,159,803,604,1661,802,804,1266,359,352,398;33;F
115200;460,358,225,470,370,359,724,933,476,491,921;43;F
115214;933,803,1632,1313,460,225,1200,1370,817,470,370,476,491,238,921;33;F
115217;460,1603,1200,470,370,1108,933,1556,603,1355,476,1101,491,1089,921;36;M
115225;358,1603,1370,159,724,933,1556,1355,476,277,491,238,921,538,352;48;M
115249;921,460,1606,331,225,1603,1200,470,803,1556,933,476,491,1089;5;F
115280;1089,1370,1313,803,1603,1200,470,370,359,724,933,476,1101,491,921;27;F
115305;331,1603,1200,803,1556,1101,491;38;F
115307;1632,1313,331,225,1603,1200,933,470,1101,476;34;M
115374;1355,460,225,1603,1200,1370,470,370,1651,359,476,491,1724,921,352;37;F
115385;921,548,943,1370,358,460,1632,1606,331,225,1603,1200,1651,476,1089;37;F
115392;1606,358,460,1313,1632,1603,1661,370,803,603,491,398,1709,548,921;25;M
115396;225,331,1370,159;33;M
115425;1200,1108,277,1101,491,1709,238,921,538;26;M
115429;1108,470,817,1370,1603,760,460,358,331,225,801,476,491,548,1089;29;F
115516;921,476,225;24;M
115563;331,1606,1089;24;F
115656;460,225,1603,1200,1370,470,370,1651,359,1355,476,491,1724,921,352;4;F
115671;370,1266,1651,803,933,395,1355,921,358,1603,1370,1556,476,491,238;44;M
115675;358,799,1603,806,1661,470,1651,803,603,853,476,805,548,238,1089;21;F
115681;476,603,1556,933,724,359,1108,159,1603,225,358,1101,491;29;F
115683;359,1370,1606,1632,460,358,331,225,1603,806,1200,803,933,476,1089;34;F
115713;358,460,331,225,1603,1200,470,370,933,1556,1355,476,1101,491,1089;22;F
115732;1313,1108,1355,1101,538;60;F
115783;358,460,1313,1632,370,359,724,933,476,491,921;30;F
115797;1632,460,331,225,1603,806,1200,470,803,724,933,1556,476,1089,921;69;F
115848;1370,238,352;51;F
115862;853,933,803,802,1200,358,460,1632,370,1108,476,1101,491,352;29;M
115865;460,225,1603,1200,1370,470,370,1651,359,1355,476,491,1724,921,352;;M
115899;460,331,225,1603,1200,159,470,933,1556,476,1101,491,238,1089,921;21;M
115943;359,358;18;F
115957;801,225,1632,1266,1651,605,359,933,603,491,238,604;22;F
116148;1355,1313,1108,1089,1101,538;67;M
116150;853;85;F
116152;853;75;M
116153;1632,352,395,238,548;67;F
116155;853;71;F
116157;1709,1632,921,491,352,1089,476,359,358,225,803;59;M
116162;1355,1313,1108,1101,538;33;M
116163;853;74;F
116165;853;77;F
116166;1661,1355,1313,1266,1108,799,1101,538;25;M
116168;853;73;F
116169;853;46;F
116170;1709,1661,1603,1355,1266,1108,724,605,760,1101,538;49;M
116172;853;49;M
116173;1355,1313,1101,538;26;F
116174;853;71;M
116175;853;77;M
116176;1355,1313,1108,1101,538;48;M
116177;1355,1313,921,491,460,1101,538,476,470,225,803;34;F
116179;1355,1313,1108,1101,538;60;M
116180;1355,1313,1108,1101,538;14;M
116181;1632,370,853;28;F
116184;1355,1108,1101,538,476,370,225;39;F
116185;853;68;F
116186;1355,1313,1108,1101,538;52;F
116188;1355,1313,605,1101,538;26;F
116189;1651,1606,1556,1370,1200,943,491,352,331,538,476,225,395,238,803;41;M
116191;1651,943,395,238;71;F
116194;853;21;F
116195;1355,1313,1108,1101,538;31;M
116196;853;61;M
116197;1355,1313,1108,1101,538;73;M
116198;853;2;M
116199;1355,1313,1108,1101,538;77;M
116200;853;40;F
116201;1355,1313,1108,352,1101,538;60;F
116202;853;43;M
116204;853;40;F
116205;853;48;M
116207;853;77;F
116209;1355,1313,1108,1101,538;18;M
116210;853;34;M
116211;1355,1313,1108,1101,538;44;M
116212;853;78;M
116213;1355,1313,1108,1101,538;37;F
116214;853;64;F
116215;853;42;F
116216;1355,1313,1108,1101,538;45;F
116217;853;77;F
116219;1355,1313,1108,1101,538;46;M
116220;1313,1108,1101,538;45;M
116223;1724,1709,1651,1606,1370,1313,943,491,460,352,1089,331,395,238,803;77;F
116224;853;51;F
116228;853;27;M
116230;853;50;F
116235;395,853;35;M
116237;1355,1313,1108,1101,538;49;M
116239;1355,1313,1108,1101,538;71;F
116241;1355,1313,1108,1101,538;50;F
116243;1355,1313,1108,352,1101,538;54;M
116245;1355,1313,1108,1101,538;58;F
116248;1355,1313,1101,538;33;F
116250;1355,1313,1108,1101,538;21;M
116251;1355,1313,1108,1101,538;25;M
116253;1355,1313,1108,1101,538;32;F
116254;1355,1313,1108,1101,538;71;F
116255;1355,1313,1108,1101,538;47;F
116258;1355,1313,1108,1101,538;63;M
116260;1355,1313,1108,1101,538;38;F
116261;1355,1313,1108,1101,538;47;F
116262;1355,1313,1108,1101,538;28;M
116265;1724,1556,1355,1313,1108,1101,538;43;F
116266;1724,1355,1108,1101,538,476;20;M
116267;1355,1313,1108,1101,538;42;F
116268;1355,1313,1108,1101,538;22;F
116269;1355,1632,1313,1108,1101,538,395,238,548,801,803,805,398,381;25;M
116270;1355,1632,1313,1108,1101,538,395,238,548,801,803,805,398,381;60;F
116271;1355,1632,1313,1108,1101,538,395,238,548,801,803,805,398,381;81;F
116272;1355,538;39;F
116273;1355,1313,1108,1101,538;37;M
116274;1355,1313,1108,1101,538;36;F
116275;1355,1313,1108,1101,538;45;M
116276;1355,1313,1108,1101,538;30;F
116277;1355,1313,1108,1101,538;50;F
99999932166;352,225,331,921,491;36;F
99999944009;352;40;F